/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.rpni;

import de.learnlib.algorithm.PassiveLearningAlgorithm;
import de.learnlib.algorithm.rpni.AbstractBlueFringeRPNI;
import de.learnlib.algorithm.rpni.MDLUtil;
import de.learnlib.datastructure.pta.BlueFringePTA;
import de.learnlib.datastructure.pta.BlueFringePTAState;
import de.learnlib.datastructure.pta.RedBlueMerge;
import de.learnlib.datastructure.pta.wrapper.DFAWrapper;
import de.learnlib.query.DefaultQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.common.smartcollection.IntSeq;

public class BlueFringeMDLDFA<I>
extends AbstractBlueFringeRPNI<I, Boolean, Boolean, Void, DFA<?, I>>
implements PassiveLearningAlgorithm.PassiveDFALearner<I> {
    private final List<IntSeq> positive = new ArrayList<IntSeq>();
    private double currentScore = Double.POSITIVE_INFINITY;

    public BlueFringeMDLDFA(Alphabet<I> alphabet) {
        super(alphabet);
    }

    @Override
    public void addSamples(Collection<? extends DefaultQuery<I, Boolean>> samples) {
        for (DefaultQuery<I, Boolean> query : samples) {
            if (!query.getOutput().booleanValue()) {
                throw new IllegalArgumentException("Only positive examples are allowed");
            }
            this.positive.add(query.getInput().asIntSeq(this.alphabet));
        }
    }

    @Override
    public DFA<?, I> computeModel() {
        super.setDeterministic(true);
        super.setParallel(false);
        return (DFA)super.computeModel();
    }

    @Override
    protected BlueFringePTA<Boolean, Void> fetchPTA() {
        BlueFringePTA<Boolean, Void> pta = new BlueFringePTA<Boolean, Void>(this.alphabet.size());
        for (IntSeq pos : this.positive) {
            pta.addSample(pos, true);
        }
        return pta;
    }

    @Override
    protected Stream<RedBlueMerge<BlueFringePTAState<Boolean, Void>, Boolean, Void>> selectMerges(Stream<RedBlueMerge<BlueFringePTAState<Boolean, Void>, Boolean, Void>> merges) {
        return merges.filter(this::decideOnValidMerge);
    }

    private boolean decideOnValidMerge(RedBlueMerge<BlueFringePTAState<Boolean, Void>, Boolean, Void> merge) {
        double score = MDLUtil.score(merge.toMergedAutomaton(), this.alphabetSize, this.positive);
        if (score < this.currentScore) {
            this.currentScore = score;
            return true;
        }
        return false;
    }

    @Override
    protected DFA<?, I> ptaToModel(BlueFringePTA<Boolean, Void> pta) {
        return new DFAWrapper(this.alphabet, pta);
    }
}

