/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.ttt.base;

import de.learnlib.algorithm.ttt.base.AbstractBaseDTNode;
import de.learnlib.algorithm.ttt.base.TTTState;
import de.learnlib.datastructure.discriminationtree.model.AbstractDiscriminationTree;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.word.Word;

public class BaseTTTDiscriminationTree<I, D>
extends AbstractDiscriminationTree<Word<I>, I, D, TTTState<I, D>, AbstractBaseDTNode<I, D>> {
    public BaseTTTDiscriminationTree(MembershipOracle<I, D> oracle, Supplier<? extends AbstractBaseDTNode<I, D>> supplier) {
        this(oracle, supplier.get());
    }

    public BaseTTTDiscriminationTree(MembershipOracle<I, D> oracle, AbstractBaseDTNode<I, D> root) {
        super(root, oracle);
    }

    public AbstractBaseDTNode<I, D> sift(Word<I> word, boolean hard) {
        return this.sift((AbstractBaseDTNode)this.getRoot(), word, hard);
    }

    public AbstractBaseDTNode<I, D> sift(AbstractBaseDTNode<I, D> start, Word<I> prefix, boolean hard) {
        return super.sift(start, prefix, BaseTTTDiscriminationTree.getSiftPredicate(hard));
    }

    public List<AbstractBaseDTNode<I, D>> sift(List<AbstractBaseDTNode<I, D>> starts, List<Word<I>> prefixes, boolean hard) {
        return super.sift(starts, prefixes, BaseTTTDiscriminationTree.getSiftPredicate(hard));
    }

    @Override
    public AbstractBaseDTNode<I, D> sift(AbstractBaseDTNode<I, D> start, Word<I> prefix) {
        return this.sift(start, prefix, true);
    }

    @Override
    public List<AbstractBaseDTNode<I, D>> sift(List<AbstractBaseDTNode<I, D>> starts, List<Word<I>> prefixes) {
        return this.sift(starts, prefixes, true);
    }

    @Override
    protected DefaultQuery<I, D> buildQuery(AbstractBaseDTNode<I, D> node, Word<I> prefix) {
        return new DefaultQuery<I, Word>(prefix, (Word)node.getDiscriminator());
    }

    private static <I, D> Predicate<AbstractBaseDTNode<I, D>> getSiftPredicate(boolean hard) {
        return n -> !n.isLeaf() && (hard || !n.isTemp());
    }

    @Override
    public VisualizationHelper<AbstractBaseDTNode<I, D>, Map.Entry<D, AbstractBaseDTNode<I, D>>> getVisualizationHelper() {
        return new VisualizationHelper<AbstractBaseDTNode<I, D>, Map.Entry<D, AbstractBaseDTNode<I, D>>>(){

            @Override
            public boolean getNodeProperties(AbstractBaseDTNode<I, D> node, Map<String, String> properties) {
                if (node.isLeaf()) {
                    properties.put("shape", "box");
                    properties.put("label", String.valueOf(node.getData()));
                } else {
                    properties.put("label", ((Word)node.getDiscriminator()).toString());
                    if (!node.isTemp()) {
                        properties.put("shape", "oval");
                    } else if (node.isBlockRoot()) {
                        properties.put("shape", "doubleoctagon");
                    } else {
                        properties.put("shape", "octagon");
                    }
                }
                return true;
            }

            @Override
            public boolean getEdgeProperties(AbstractBaseDTNode<I, D> src, Map.Entry<D, AbstractBaseDTNode<I, D>> edge, AbstractBaseDTNode<I, D> tgt, Map<String, String> properties) {
                properties.put("label", String.valueOf(edge.getValue().getParentOutcome()));
                return true;
            }
        };
    }
}

