/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.ttt.base;

import de.learnlib.AccessSequenceProvider;
import de.learnlib.algorithm.ttt.base.AbstractBaseDTNode;
import de.learnlib.algorithm.ttt.base.TTTState;
import de.learnlib.datastructure.list.IntrusiveListElem;
import de.learnlib.datastructure.list.IntrusiveListElemImpl;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TTTTransition<I, D>
extends IntrusiveListElemImpl<TTTTransition<I, D>>
implements AccessSequenceProvider<I> {
    private final TTTState<I, D> source;
    private final I input;
    protected IntrusiveListElem<TTTTransition<I, D>> prevIncoming;
    AbstractBaseDTNode<I, D> nonTreeTarget;
    private TTTState<I, D> treeTarget;

    public TTTTransition(TTTState<I, D> source, I input) {
        this.source = source;
        this.input = input;
    }

    public TTTState<I, D> getTreeTarget() {
        assert (this.isTree());
        return this.treeTarget;
    }

    public boolean isTree() {
        return this.treeTarget != null;
    }

    public AbstractBaseDTNode<I, D> getNonTreeTarget() {
        assert (!this.isTree());
        return this.nonTreeTarget;
    }

    void setNonTreeTarget(AbstractBaseDTNode<I, D> nonTreeTarget) {
        this.nonTreeTarget = nonTreeTarget;
        nonTreeTarget.getIncoming().insertIncoming(this);
    }

    public AbstractBaseDTNode<I, D> getDTTarget() {
        if (this.treeTarget != null) {
            return this.treeTarget.dtLeaf;
        }
        return this.nonTreeTarget;
    }

    public TTTState<I, D> getTarget() {
        if (this.treeTarget != null) {
            return this.treeTarget;
        }
        assert (this.nonTreeTarget.isLeaf()) : "transition target is not a leaf, but is a " + (this.nonTreeTarget.isTemp() ? "temp" : "non-temp") + " node with discr" + this.nonTreeTarget.getDiscriminator();
        assert (this.nonTreeTarget.getData() != null);
        return (TTTState)this.nonTreeTarget.getData();
    }

    public TTTState<I, D> getSource() {
        return this.source;
    }

    public I getInput() {
        return this.input;
    }

    protected @Nullable Object getProperty() {
        return null;
    }

    @Override
    public Word<I> getAccessSequence() {
        WordBuilder<I> wb = new WordBuilder<I>();
        TTTTransition<I, D> curr = this;
        while (curr != null) {
            wb.add(curr.input);
            curr = curr.source.getParentTransition();
        }
        return wb.reverse().toWord();
    }

    void makeTree(TTTState<I, D> treeTarget) {
        this.removeFromList();
        this.treeTarget = treeTarget;
        this.nonTreeTarget = null;
    }

    void removeFromList() {
        if (this.prevIncoming != null) {
            this.prevIncoming.setNextElement((TTTTransition)this.next);
        }
        if (this.next != null) {
            ((TTTTransition)this.next).prevIncoming = this.prevIncoming;
        }
    }
}

