/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.counterexample;

import de.learnlib.AccessSequenceTransformer;
import de.learnlib.acex.AcexAnalyzers;
import de.learnlib.counterexample.AcexLocalSuffixFinder;
import de.learnlib.counterexample.LocalSuffixFinder;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.Query;
import net.automatalib.automaton.concept.SuffixOutput;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LocalSuffixFinders {
    public static final LocalSuffixFinder<@Nullable Object, @Nullable Object> FIND_LINEAR = new AcexLocalSuffixFinder(AcexAnalyzers.LINEAR_FWD, true, "FindLinear");
    public static final LocalSuffixFinder<@Nullable Object, @Nullable Object> FIND_LINEAR_REVERSE = new AcexLocalSuffixFinder(AcexAnalyzers.LINEAR_BWD, true, "FindLinear-Reverse");
    public static final LocalSuffixFinder<@Nullable Object, @Nullable Object> RIVEST_SCHAPIRE = new AcexLocalSuffixFinder(AcexAnalyzers.BINARY_SEARCH_BWD, true, "RivestSchapire");

    private LocalSuffixFinders() {
    }

    public static <I, D> int findLinear(Query<I, D> ceQuery, AccessSequenceTransformer<I> asTransformer, SuffixOutput<I, D> hypOutput, MembershipOracle<I, D> oracle) {
        return AcexLocalSuffixFinder.findSuffixIndex(AcexAnalyzers.LINEAR_FWD, true, ceQuery, asTransformer, hypOutput, oracle);
    }

    public static <I, D> int findLinearReverse(Query<I, D> ceQuery, AccessSequenceTransformer<I> asTransformer, SuffixOutput<I, D> hypOutput, MembershipOracle<I, D> oracle) {
        return AcexLocalSuffixFinder.findSuffixIndex(AcexAnalyzers.LINEAR_BWD, true, ceQuery, asTransformer, hypOutput, oracle);
    }

    public static <I, D> int findRivestSchapire(Query<I, D> ceQuery, AccessSequenceTransformer<I> asTransformer, SuffixOutput<I, D> hypOutput, MembershipOracle<I, D> oracle) {
        return AcexLocalSuffixFinder.findSuffixIndex(AcexAnalyzers.BINARY_SEARCH_BWD, true, ceQuery, asTransformer, hypOutput, oracle);
    }

    public static LocalSuffixFinder<@Nullable Object, @Nullable Object>[] values() {
        return new LocalSuffixFinder[]{FIND_LINEAR, FIND_LINEAR_REVERSE, RIVEST_SCHAPIRE};
    }
}

