/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.pta;

import de.learnlib.datastructure.pta.AbstractBasePTAState;
import de.learnlib.datastructure.pta.PTATransition;
import java.awt.Color;
import net.automatalib.common.util.comparison.CmpUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractBlueFringePTAState<S extends AbstractBlueFringePTAState<S, SP, TP>, SP, TP>
extends AbstractBasePTAState<S, SP, TP>
implements Comparable<S> {
    protected boolean isCopy;
    protected Color color = Color.WHITE;
    protected @Nullable S parent;
    protected int parentInput = -1;
    protected int @Nullable [] access;

    public Color getColor() {
        return this.color;
    }

    @Override
    public S copy() {
        AbstractBlueFringePTAState copy = (AbstractBlueFringePTAState)super.copy();
        copy.isCopy = true;
        return (S)copy;
    }

    @Override
    public void setSuccessor(int index, S successor, int alphabetSize) {
        super.setSuccessor(index, successor, alphabetSize);
        ((AbstractBlueFringePTAState)successor).parent = this;
        ((AbstractBlueFringePTAState)successor).parentInput = index;
    }

    @Override
    protected S createSuccessor(int index) {
        AbstractBlueFringePTAState state = (AbstractBlueFringePTAState)super.createSuccessor(index);
        state.parent = this;
        state.parentInput = index;
        return (S)state;
    }

    public PTATransition<S> makeBlue() {
        if (!this.isWhite()) {
            throw new IllegalStateException();
        }
        assert (this.parent != null);
        if (!((AbstractBlueFringePTAState)this.parent).isRed()) {
            throw new IllegalStateException();
        }
        this.color = Color.BLUE;
        return new PTATransition<S>(this.parent, this.parentInput);
    }

    public boolean isWhite() {
        return this.color == Color.WHITE;
    }

    public boolean isRed() {
        return this.color == Color.RED;
    }

    public void makeRed(int id) {
        this.color = Color.RED;
        this.id = id;
        this.buildAccess();
    }

    private void buildAccess() {
        if (this.access != null) {
            throw new IllegalStateException();
        }
        if (this.parent == null) {
            this.access = new int[0];
            return;
        }
        int[] parentAccess = ((AbstractBlueFringePTAState)this.parent).access;
        if (parentAccess == null) {
            throw new IllegalStateException();
        }
        int paLen = parentAccess.length;
        this.access = new int[paLen + 1];
        System.arraycopy(parentAccess, 0, this.access, 0, paLen);
        this.access[paLen] = this.parentInput;
    }

    public boolean isBlue() {
        return this.color == Color.BLUE;
    }

    @Override
    public int compareTo(S other) {
        if (this == other) {
            return 0;
        }
        if (this.access == null) {
            if (((AbstractBlueFringePTAState)other).access == null) {
                return 0;
            }
            return 1;
        }
        if (((AbstractBlueFringePTAState)other).access == null) {
            return -1;
        }
        return CmpUtil.canonicalCompare(this.access, ((AbstractBlueFringePTAState)other).access);
    }

    public int lexCompareTo(S other) {
        if (this == other) {
            return 0;
        }
        if (this.access == null) {
            if (((AbstractBlueFringePTAState)other).access == null) {
                return 0;
            }
            return 1;
        }
        if (((AbstractBlueFringePTAState)other).access == null) {
            return -1;
        }
        return CmpUtil.lexCompare(this.access, ((AbstractBlueFringePTAState)other).access);
    }

    public void setForeignSuccessor(int index, S successor, int alphabetSize) {
        super.setSuccessor(index, successor, alphabetSize);
    }
}

