/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.pta.wrapper;

import de.learnlib.datastructure.pta.AbstractBasePTAState;
import de.learnlib.datastructure.pta.BasePTA;
import de.learnlib.datastructure.pta.PTATransition;
import java.util.Collection;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.FiniteAlphabetAutomaton;
import net.automatalib.automaton.transducer.MooreMachine;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MooreWrapper<S extends AbstractBasePTAState<S, O, Void>, I, O>
implements MooreMachine<S, I, PTATransition<S>, O>,
FiniteAlphabetAutomaton<S, I, PTATransition<S>> {
    private final Alphabet<I> alphabet;
    private final BasePTA<S, O, Void> pta;

    public MooreWrapper(Alphabet<I> alphabet, BasePTA<S, O, Void> pta) {
        assert (alphabet.size() == pta.getInputAlphabet().size());
        this.alphabet = alphabet;
        this.pta = pta;
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    @Override
    public O getStateOutput(S state) {
        return this.pta.getStateProperty(state);
    }

    @Override
    public Collection<S> getStates() {
        return this.pta.getStates();
    }

    @Override
    public @Nullable PTATransition<S> getTransition(S state, I input) {
        return this.pta.getTransition(state, this.alphabet.getSymbolIndex(input));
    }

    @Override
    public S getSuccessor(PTATransition<S> transition) {
        return this.pta.getSuccessor(transition);
    }

    @Override
    public @Nullable S getInitialState() {
        return (S)this.pta.getInitialState();
    }
}

