/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.driver.reflect;

import de.learnlib.driver.reflect.MethodOutput;
import de.learnlib.driver.reflect.ReturnValue;
import de.learnlib.driver.reflect.VoidOutput;
import de.learnlib.exception.SULException;
import de.learnlib.sul.ContextExecutableInput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodInput
implements ContextExecutableInput<MethodOutput, Object> {
    private final String displayName;
    private final Method method;
    private final Object[] parameters;

    public MethodInput(String displayName, Method method, Object[] parameters) {
        this.displayName = displayName;
        this.method = method;
        this.parameters = parameters;
    }

    @Override
    public MethodOutput execute(Object context) {
        try {
            Object ret = this.method.invoke(context, this.parameters);
            if (Void.TYPE.equals(this.method.getReturnType())) {
                return VoidOutput.INSTANCE;
            }
            return new ReturnValue<Object>(ret);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new SULException(e);
        }
        catch (InvocationTargetException e) {
            throw new SULException(e.getCause());
        }
    }

    public String toString() {
        return this.displayName;
    }
}

