/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.driver.simulator;

import de.learnlib.sul.SUL;
import net.automatalib.automaton.transducer.MealyMachine;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MealySimulatorSUL<I, O>
implements SUL<I, O> {
    private final MealySimulatorSULImpl<?, I, ?, O> impl;

    public MealySimulatorSUL(MealyMachine<?, I, ?, O> mealy) {
        this(mealy, null);
    }

    public MealySimulatorSUL(MealyMachine<?, I, ?, O> mealy, O noTransOut) {
        this(new MealySimulatorSULImpl(mealy, noTransOut));
    }

    MealySimulatorSUL(MealySimulatorSULImpl<?, I, ?, O> impl) {
        this.impl = impl;
    }

    @Override
    public void pre() {
        this.impl.pre();
    }

    @Override
    public void post() {
        this.impl.post();
    }

    @Override
    public O step(I in) {
        return this.impl.step(in);
    }

    @Override
    public boolean canFork() {
        return this.impl.canFork();
    }

    @Override
    public SUL<I, O> fork() {
        return new MealySimulatorSUL<I, O>(this.impl.fork());
    }

    static class MealySimulatorSULImpl<S, I, T, O>
    implements SUL<I, O> {
        private final MealyMachine<S, I, T, O> mealy;
        private final O noTransOut;
        private @Nullable S curr;

        MealySimulatorSULImpl(MealyMachine<S, I, T, O> mealy, O noTransOut) {
            this.mealy = mealy;
            this.noTransOut = noTransOut;
        }

        @Override
        public void pre() {
            this.curr = this.mealy.getInitialState();
        }

        @Override
        public void post() {
            this.curr = null;
        }

        @Override
        public O step(I in) {
            O out = this.noTransOut;
            if (this.curr != null) {
                Object trans = this.mealy.getTransition(this.curr, in);
                if (trans != null) {
                    out = this.mealy.getTransitionOutput(trans);
                    this.curr = this.mealy.getSuccessor(trans);
                } else {
                    this.curr = null;
                }
            }
            return out;
        }

        @Override
        public boolean canFork() {
            return true;
        }

        public MealySimulatorSULImpl<S, I, T, O> fork() {
            return new MealySimulatorSULImpl<S, I, T, O>(this.mealy, this.noTransOut);
        }

        S getCurr() {
            if (this.curr == null) {
                throw new IllegalStateException("SUL was not properly initialized");
            }
            return this.curr;
        }
    }
}

