/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.dfa;

import de.learnlib.Resumable;
import de.learnlib.filter.cache.LearningCacheOracle;
import de.learnlib.filter.cache.dfa.DFAHashCacheConsistencyTest;
import de.learnlib.filter.cache.dfa.ProxyQuery;
import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.word.Word;

public class DFAHashCacheOracle<I>
implements LearningCacheOracle.DFALearningCacheOracle<I>,
Resumable<DFAHashCacheOracleState<I>> {
    private final MembershipOracle<I, Boolean> delegate;
    private Map<Word<I>, Boolean> cache;

    DFAHashCacheOracle(MembershipOracle<I, Boolean> delegate) {
        this(delegate, new HashMap<Word<I>, Boolean>());
    }

    DFAHashCacheOracle(MembershipOracle<I, Boolean> delegate, Map<Word<I>, Boolean> cache) {
        this.delegate = delegate;
        this.cache = cache;
    }

    @Override
    public EquivalenceOracle<DFA<?, I>, I, Boolean> createCacheConsistencyTest() {
        return new DFAHashCacheConsistencyTest<I>(this.cache);
    }

    @Override
    public void processQueries(Collection<? extends Query<I, Boolean>> queries) {
        ArrayList<ProxyQuery<I>> misses = new ArrayList<ProxyQuery<I>>();
        ArrayList<Query<I, Boolean>> duplicates = new ArrayList<Query<I, Boolean>>();
        HashSet<Word<I>> batchCache = new HashSet<Word<I>>();
        for (Query<I, Boolean> query : queries) {
            Word<I> input = query.getInput();
            Boolean answer = this.cache.get(input);
            if (answer != null) {
                query.answer(answer);
                continue;
            }
            if (batchCache.add(input)) {
                misses.add(new ProxyQuery<I>(query));
                continue;
            }
            duplicates.add(query);
        }
        this.delegate.processQueries(misses);
        for (ProxyQuery proxyQuery : misses) {
            this.cache.put(proxyQuery.getInput(), proxyQuery.getAnswer());
        }
        if (!duplicates.isEmpty()) {
            for (Query<I, Boolean> query : duplicates) {
                query.answer(this.cache.get(query.getInput()));
            }
        }
    }

    @Override
    public DFAHashCacheOracleState<I> suspend() {
        return new DFAHashCacheOracleState<I>(this.cache);
    }

    @Override
    public void resume(DFAHashCacheOracleState<I> state) {
        this.cache = state.getCache();
    }

    public static class DFAHashCacheOracleState<I> {
        private final Map<Word<I>, Boolean> cache;

        public DFAHashCacheOracleState(Map<Word<I>, Boolean> cache) {
            this.cache = cache;
        }

        public Map<Word<I>, Boolean> getCache() {
            return this.cache;
        }
    }
}

