/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.mealy;

import de.learnlib.filter.cache.mealy.MealyCacheOracle;
import de.learnlib.filter.cache.mealy.SymbolQueryCache;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.oracle.SymbolQueryOracle;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.common.util.mapping.Mapping;
import net.automatalib.incremental.mealy.dag.IncrementalMealyDAGBuilder;
import net.automatalib.incremental.mealy.tree.DynamicIncrementalMealyTreeBuilder;
import net.automatalib.incremental.mealy.tree.IncrementalMealyTreeBuilder;
import net.automatalib.word.Word;

public final class MealyCaches {
    private MealyCaches() {
    }

    public static <I, O> MealyCacheOracle<I, O> createCache(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> mqOracle) {
        return MealyCaches.createDAGCache(alphabet, mqOracle);
    }

    public static <I, O> MealyCacheOracle<I, O> createDAGCache(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> mqOracle) {
        return new MealyCacheOracle(new IncrementalMealyDAGBuilder(alphabet), null, mqOracle, alphabet);
    }

    public static <I, O> MealyCacheOracle<I, O> createDAGCache(Alphabet<I> alphabet, Mapping<? super O, ? extends O> errorSyms, MembershipOracle<I, Word<O>> mqOracle) {
        return new MealyCacheOracle<I, O>(new IncrementalMealyDAGBuilder(alphabet), errorSyms, mqOracle, alphabet);
    }

    public static <I, O> MealyCacheOracle<I, O> createTreeCache(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> mqOracle) {
        return new MealyCacheOracle(new IncrementalMealyTreeBuilder(alphabet), null, mqOracle, alphabet);
    }

    public static <I, O> MealyCacheOracle<I, O> createTreeCache(Alphabet<I> alphabet, Mapping<? super O, ? extends O> errorSyms, MembershipOracle<I, Word<O>> mqOracle) {
        return new MealyCacheOracle<I, O>(new IncrementalMealyTreeBuilder(alphabet), errorSyms, mqOracle, alphabet);
    }

    public static <I, O> MealyCacheOracle<I, O> createDynamicTreeCache(MembershipOracle<I, Word<O>> mqOracle) {
        return new MealyCacheOracle(new DynamicIncrementalMealyTreeBuilder(), null, mqOracle);
    }

    public static <I, O> MealyCacheOracle<I, O> createDynamicTreeCache(Mapping<? super O, ? extends O> errorSyms, MembershipOracle<I, Word<O>> mqOracle) {
        return new MealyCacheOracle(new DynamicIncrementalMealyTreeBuilder(), errorSyms, mqOracle);
    }

    public static <I, O> SymbolQueryCache<I, O> createSymbolQueryCache(Alphabet<I> alphabet, SymbolQueryOracle<I, O> mqOracle) {
        return new SymbolQueryCache<I, O>(mqOracle, alphabet);
    }
}

