/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.reuse;

import de.learnlib.filter.reuse.ReuseCapableOracle;
import de.learnlib.filter.reuse.tree.BoundedDeque;
import de.learnlib.filter.reuse.tree.ReuseNode;
import de.learnlib.filter.reuse.tree.ReuseTree;
import de.learnlib.filter.reuse.tree.SystemStateHandler;
import de.learnlib.oracle.SingleQueryOracle;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

public final class ReuseOracle<S, I, O>
implements SingleQueryOracle.SingleQueryOracleMealy<I, O> {
    private final ThreadLocal<ReuseCapableOracle<S, I, O>> executableOracles;
    private final ReuseTree<S, I, O> tree;

    ReuseOracle(ReuseOracleBuilder<S, I, O> builder) {
        this.executableOracles = ThreadLocal.withInitial(((ReuseOracleBuilder)builder).oracleSupplier);
        this.tree = new ReuseTree.ReuseTreeBuilder(((ReuseOracleBuilder)builder).alphabet).withSystemStateHandler(((ReuseOracleBuilder)builder).systemStateHandler).withFailureOutputs(((ReuseOracleBuilder)builder).failureOutputSymbols).withInvariantInputs(((ReuseOracleBuilder)builder).invariantInputSymbols).withEnabledSystemstateInvalidation(((ReuseOracleBuilder)builder).invalidateSystemStates).withMaxSystemStates(((ReuseOracleBuilder)builder).maxSystemStates).withAccessPolicy(((ReuseOracleBuilder)builder).accessPolicy).withEvictPolicy(((ReuseOracleBuilder)builder).evictPolicy).build();
    }

    @Override
    public Word<O> answerQuery(Word<I> prefix, Word<I> suffix) {
        return this.processQuery(prefix.concat(suffix)).suffix(suffix.length());
    }

    @Override
    public Word<O> answerQuery(Word<I> input) {
        return this.processQuery(input);
    }

    private Word<O> processQuery(Word<I> query) {
        Word output;
        Word<O> knownOutput = this.tree.getOutput(query);
        if (knownOutput != null) {
            return knownOutput;
        }
        ReuseNode.NodeResult<S, I, O> nodeResult = this.tree.fetchSystemState(query);
        ReuseCapableOracle oracle = this.getReuseCapableOracle();
        if (nodeResult == null) {
            ReuseCapableOracle.QueryResult<S, O> newResult = this.filterAndProcessQuery(query, this.tree.getPartialOutput(query), oracle::processQuery);
            this.tree.insert(query, newResult);
            output = newResult.output;
        } else {
            int suffixLen = query.size() - nodeResult.prefixLength;
            Word<I> suffix = query.suffix(suffixLen);
            Word<O> partialOutput = this.tree.getPartialOutput(query);
            Word<O> partialSuffixOutput = partialOutput.suffix(suffixLen);
            ReuseNode reuseNode = nodeResult.reuseNode;
            Object systemState = nodeResult.systemState;
            ReuseCapableOracle.QueryResult<S, O> suffixQueryResult = this.filterAndProcessQuery(suffix, partialSuffixOutput, filteredInput -> oracle.continueQuery((Word)filteredInput, systemState));
            this.tree.insert(suffix, reuseNode, suffixQueryResult);
            Word<O> prefixOutput = this.tree.getOutput(query.prefix(nodeResult.prefixLength));
            output = new WordBuilder<O>(prefixOutput).append(suffixQueryResult.output).toWord();
        }
        return output;
    }

    public ReuseCapableOracle<S, I, O> getReuseCapableOracle() {
        return this.executableOracles.get();
    }

    private ReuseCapableOracle.QueryResult<S, O> filterAndProcessQuery(Word<I> query, Word<O> partialOutput, Function<Word<I>, ReuseCapableOracle.QueryResult<S, O>> processQuery) {
        LinkedList<I> filteredQueryList = new LinkedList<I>(query.asList());
        Iterator queryIterator = filteredQueryList.iterator();
        for (O outputSymbol : partialOutput) {
            queryIterator.next();
            if (outputSymbol == null) continue;
            queryIterator.remove();
        }
        ReuseCapableOracle.QueryResult<S, O> res = processQuery.apply(Word.fromList(filteredQueryList));
        WordBuilder<O> wordBuilder = new WordBuilder<O>();
        Iterator resultIterator = res.output.iterator();
        for (O output : partialOutput) {
            if (output == null) {
                wordBuilder.add((O)resultIterator.next());
                continue;
            }
            wordBuilder.add(output);
        }
        return new ReuseCapableOracle.QueryResult(wordBuilder.toWord(), res.newState);
    }

    public ReuseTree<S, I, O> getReuseTree() {
        return this.tree;
    }

    public static class ReuseOracleBuilder<S, I, O> {
        private final Alphabet<I> alphabet;
        private final Supplier<? extends ReuseCapableOracle<S, I, O>> oracleSupplier;
        private boolean invalidateSystemStates = true;
        private SystemStateHandler<S> systemStateHandler;
        private Set<I> invariantInputSymbols;
        private Set<O> failureOutputSymbols;
        private int maxSystemStates = -1;
        private BoundedDeque.AccessPolicy accessPolicy = BoundedDeque.AccessPolicy.LIFO;
        private BoundedDeque.EvictPolicy evictPolicy = BoundedDeque.EvictPolicy.EVICT_OLDEST;

        public ReuseOracleBuilder(Alphabet<I> alphabet, Supplier<? extends ReuseCapableOracle<S, I, O>> oracleSupplier) {
            this.alphabet = alphabet;
            this.oracleSupplier = oracleSupplier;
        }

        public ReuseOracleBuilder<S, I, O> withSystemStateHandler(SystemStateHandler<S> systemStateHandler) {
            this.systemStateHandler = systemStateHandler;
            return this;
        }

        public ReuseOracleBuilder<S, I, O> withEnabledSystemStateInvalidation(boolean invalidate) {
            this.invalidateSystemStates = invalidate;
            return this;
        }

        public ReuseOracleBuilder<S, I, O> withInvariantInputs(Set<I> inputs) {
            this.invariantInputSymbols = inputs;
            return this;
        }

        public ReuseOracleBuilder<S, I, O> withFailureOutputs(Set<O> outputs) {
            this.failureOutputSymbols = outputs;
            return this;
        }

        public ReuseOracleBuilder<S, I, O> withMaxSystemStates(int maxSystemStates) {
            this.maxSystemStates = maxSystemStates;
            return this;
        }

        public ReuseOracleBuilder<S, I, O> withAccessPolicy(BoundedDeque.AccessPolicy accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        public ReuseOracleBuilder<S, I, O> withEvictPolicy(BoundedDeque.EvictPolicy evictPolicy) {
            this.evictPolicy = evictPolicy;
            return this;
        }

        public ReuseOracle<S, I, O> build() {
            return new ReuseOracle(this);
        }
    }
}

