/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.reuse.tree;

import de.learnlib.filter.reuse.tree.BoundedDeque;
import de.learnlib.filter.reuse.tree.ReuseEdge;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ReuseNode<S, I, O> {
    private final @Nullable ReuseEdge<S, I, O>[] edges;
    private final BoundedDeque<S> systemStates;
    private final int id;

    public ReuseNode(int id, int alphabetSize, int maxSystemStates, BoundedDeque.AccessPolicy accessPolicy, BoundedDeque.EvictPolicy evictPolicy) {
        this.edges = new ReuseEdge[alphabetSize];
        this.id = id;
        this.systemStates = new BoundedDeque(maxSystemStates, accessPolicy, evictPolicy);
    }

    public S fetchSystemState(boolean remove) {
        if (remove) {
            return this.systemStates.retrieve();
        }
        return this.systemStates.peek();
    }

    public @Nullable S addSystemState(S state) {
        return this.systemStates.insert(state);
    }

    public Iterator<S> systemStatesIterator() {
        return this.systemStates.iterator();
    }

    public boolean hasSystemStates() {
        return !this.systemStates.isEmpty();
    }

    public void clearSystemStates() {
        this.systemStates.clear();
    }

    public Collection<@Nullable ReuseEdge<S, I, O>> getEdges() {
        return Arrays.asList(this.edges);
    }

    public void addEdge(int index, ReuseEdge<S, I, O> edge) {
        this.edges[index] = edge;
    }

    public @Nullable ReuseNode<S, I, O> getTargetNodeForInput(int index) {
        ReuseEdge<S, I, O> edge = this.getEdgeWithInput(index);
        if (edge == null) {
            return null;
        }
        return edge.getTarget();
    }

    public @Nullable ReuseEdge<S, I, O> getEdgeWithInput(int index) {
        return this.edges[index];
    }

    public int getId() {
        return this.id;
    }

    public static final class NodeResult<S, I, O> {
        public final ReuseNode<S, I, O> reuseNode;
        public final S systemState;
        public final int prefixLength;

        public NodeResult(ReuseNode<S, I, O> reuseNode, S systemState, int prefixLength) {
            this.reuseNode = reuseNode;
            this.systemState = systemState;
            this.prefixLength = prefixLength;
        }
    }
}

