/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.reuse.tree;

import de.learnlib.filter.reuse.tree.ReuseEdge;
import de.learnlib.filter.reuse.tree.ReuseNode;
import java.util.Map;
import net.automatalib.visualization.DefaultVisualizationHelper;
import org.checkerframework.checker.nullness.qual.Nullable;

class ReuseTreeDotHelper<S, I, O>
extends DefaultVisualizationHelper<ReuseNode<S, I, O>, ReuseEdge<S, I, O>> {
    ReuseTreeDotHelper() {
    }

    @Override
    public boolean getNodeProperties(@Nullable ReuseNode<S, I, O> node, Map<String, String> properties) {
        if (node == null) {
            return false;
        }
        super.getNodeProperties(node, properties);
        if (node.hasSystemStates()) {
            properties.put("color", "black");
            properties.put("style", "filled");
            properties.put("shape", "diamond");
            properties.put("fontcolor", "white");
        }
        properties.put("label", String.valueOf(node.getId()));
        return true;
    }

    @Override
    public boolean getEdgeProperties(@Nullable ReuseNode<S, I, O> src, @Nullable ReuseEdge<S, I, O> edge, @Nullable ReuseNode<S, I, O> tgt, Map<String, String> properties) {
        if (src == null || edge == null || tgt == null) {
            return false;
        }
        super.getEdgeProperties(src, edge, tgt, properties);
        StringBuilder labelBuilder = new StringBuilder();
        labelBuilder.append(edge.getInput()).append(" / ");
        O output = edge.getOutput();
        if (output != null) {
            labelBuilder.append(output);
        }
        properties.put("label", labelBuilder.toString());
        return true;
    }
}

