/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.statistic.learner;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.filter.statistic.Counter;
import de.learnlib.query.DefaultQuery;
import de.learnlib.statistic.StatisticLearner;

public class RefinementCounterLearner<M, I, D>
implements StatisticLearner<M, I, D> {
    private final LearningAlgorithm<M, I, D> learningAlgorithm;
    private final Counter counter;

    public RefinementCounterLearner(LearningAlgorithm<M, I, D> learningAlgorithm) {
        this.learningAlgorithm = learningAlgorithm;
        this.counter = new Counter("Refinements", "#");
    }

    @Override
    public void startLearning() {
        this.learningAlgorithm.startLearning();
    }

    @Override
    public boolean refineHypothesis(DefaultQuery<I, D> ceQuery) {
        boolean refined = this.learningAlgorithm.refineHypothesis(ceQuery);
        if (refined) {
            this.counter.increment();
        }
        return refined;
    }

    @Override
    public M getHypothesisModel() {
        return this.learningAlgorithm.getHypothesisModel();
    }

    @Override
    public Counter getStatisticalData() {
        return this.counter;
    }
}

