/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import de.learnlib.logging.Category;
import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import net.automatalib.automaton.concept.Output;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestWordEQOracle<A extends Output<I, D>, I, D>
implements EquivalenceOracle<A, I, D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTestWordEQOracle.class);
    private final MembershipOracle<I, D> membershipOracle;
    private final int batchSize;

    public AbstractTestWordEQOracle(MembershipOracle<I, D> membershipOracle) {
        this(membershipOracle, 1);
    }

    public AbstractTestWordEQOracle(MembershipOracle<I, D> membershipOracle, int batchSize) {
        Preconditions.checkArgument(batchSize > 0);
        this.membershipOracle = membershipOracle;
        this.batchSize = batchSize;
    }

    @Override
    public @Nullable DefaultQuery<I, D> findCounterExample(A hypothesis, Collection<? extends I> inputs) {
        if (inputs.isEmpty()) {
            LOGGER.warn(Category.COUNTEREXAMPLE, "Passed empty set of inputs to equivalence oracle; no counterexample can be found!");
            return null;
        }
        Stream<Word<I>> testWordStream = this.generateTestWords(hypothesis, inputs);
        Stream<DefaultQuery<I, D>> queryStream = testWordStream.map(DefaultQuery::new);
        Stream<DefaultQuery<I, D>> answeredQueryStream = this.answerQueries(queryStream);
        Stream<DefaultQuery> ceStream = answeredQueryStream.filter(query -> {
            Object hypOutput = hypothesis.computeOutput(query.getInput());
            return !Objects.equals(hypOutput, query.getOutput());
        });
        return ceStream.findFirst().orElse(null);
    }

    protected abstract Stream<Word<I>> generateTestWords(A var1, Collection<? extends I> var2);

    private Stream<DefaultQuery<I, D>> answerQueries(Stream<DefaultQuery<I, D>> stream) {
        if (this.isBatched()) {
            return Streams.stream(Iterators.partition(stream.iterator(), this.batchSize)).peek(this.membershipOracle::processQueries).flatMap(Collection::stream);
        }
        return stream.peek(this.membershipOracle::processQuery);
    }

    private boolean isBatched() {
        return this.batchSize > 1;
    }
}

