/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence.spa;

import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.query.DefaultQuery;
import java.util.Collection;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.procedural.SPA;
import net.automatalib.util.automaton.procedural.SPAs;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimulatorEQOracle<I>
implements EquivalenceOracle<SPA<?, I>, I, Boolean> {
    private final SPA<?, I> spa;

    public SimulatorEQOracle(SPA<?, I> spa) {
        this.spa = spa;
    }

    @Override
    public @Nullable DefaultQuery<I, Boolean> findCounterExample(SPA<?, I> hypothesis, Collection<? extends I> inputs) {
        if (!(inputs instanceof ProceduralInputAlphabet)) {
            throw new IllegalArgumentException("Inputs are not a procedural alphabet");
        }
        ProceduralInputAlphabet alphabet = (ProceduralInputAlphabet)inputs;
        Word<I> sep = SPAs.findSeparatingWord(this.spa, hypothesis, alphabet);
        if (sep == null) {
            return null;
        }
        return new DefaultQuery<I, Object>(sep, this.spa.computeOutput((Iterable)sep));
    }
}

