/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.membership;

import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.Query;
import de.learnlib.sul.StateLocalInputSUL;
import java.util.Collection;
import java.util.Collections;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

public class StateLocalInputSULOracle<I, O>
implements MembershipOracle.MealyMembershipOracle<I, O> {
    private final StateLocalInputSUL<I, O> sul;
    private final O undefinedOutput;

    public StateLocalInputSULOracle(StateLocalInputSUL<I, O> sul, O undefinedOutput) {
        this.sul = sul;
        this.undefinedOutput = undefinedOutput;
    }

    @Override
    public void processQueries(Collection<? extends Query<I, Word<O>>> queries) {
        for (Query<I, Word<O>> q : queries) {
            Object output = this.answerQuery((Word)q.getPrefix(), (Word)q.getSuffix());
            q.answer((Word<O>)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Word<O> answerQuery(Word<I> prefix, Word<I> suffix) {
        try {
            this.sul.pre();
            Collection<I> enabledInputs = this.sul.currentlyEnabledInputs();
            for (I sym : prefix) {
                if (enabledInputs.contains(sym)) {
                    this.sul.step(sym);
                    enabledInputs = this.sul.currentlyEnabledInputs();
                    continue;
                }
                enabledInputs = Collections.emptySet();
            }
            WordBuilder<O> wb = new WordBuilder<O>(suffix.length());
            for (I sym : suffix) {
                if (enabledInputs.contains(sym)) {
                    Object out = this.sul.step(sym);
                    enabledInputs = this.sul.currentlyEnabledInputs();
                    wb.add((O)out);
                    continue;
                }
                enabledInputs = Collections.emptySet();
                wb.add(this.undefinedOutput);
            }
            Word word = wb.toWord();
            return word;
        }
        finally {
            this.sul.post();
        }
    }
}

