/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.parallelism;

import com.google.common.base.Throwables;
import de.learnlib.oracle.parallelism.BatchInterruptedException;
import de.learnlib.oracle.parallelism.BatchProcessor;
import de.learnlib.oracle.parallelism.StaticQueriesJob;
import de.learnlib.oracle.parallelism.ThreadPool;
import de.learnlib.setting.LearnLibProperty;
import de.learnlib.setting.LearnLibSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.automatalib.common.smartcollection.ArrayStorage;
import org.checkerframework.checker.index.qual.NonNegative;

public abstract class AbstractStaticBatchProcessor<Q, P extends BatchProcessor<Q>>
implements ThreadPool,
BatchProcessor<Q> {
    private static final int DEFAULT_MIN_BATCH_SIZE = 10;
    public static final int MIN_BATCH_SIZE;
    public static final int NUM_INSTANCES;
    public static final ThreadPool.PoolPolicy POOL_POLICY;
    private final @NonNegative int minBatchSize;
    private final ArrayStorage<P> oracles;
    private final ExecutorService executor;

    public AbstractStaticBatchProcessor(Collection<? extends P> oracles, @NonNegative int minBatchSize, ThreadPool.PoolPolicy policy) {
        this.oracles = new ArrayStorage<P>(oracles);
        switch (policy) {
            case FIXED: {
                this.executor = Executors.newFixedThreadPool(this.oracles.size() - 1);
                break;
            }
            case CACHED: {
                this.executor = Executors.newCachedThreadPool();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal pool policy: " + (Object)((Object)policy));
            }
        }
        this.minBatchSize = minBatchSize;
    }

    @Override
    public void processBatch(Collection<? extends Q> queries) {
        int externalBatches;
        int num = queries.size();
        if (num == 0) {
            return;
        }
        int numBatches = (num - this.minBatchSize) / this.minBatchSize + 1;
        if (numBatches > this.oracles.size()) {
            numBatches = this.oracles.size();
        }
        if ((externalBatches = numBatches - 1) == 0) {
            this.processQueriesLocally(queries);
            return;
        }
        int fullBatchSize = (num - 1) / numBatches + 1;
        int nonFullBatches = fullBatchSize * numBatches - num;
        ArrayList futures = new ArrayList(externalBatches);
        Iterator<Q> queryIt = queries.iterator();
        for (int i = 0; i < externalBatches; ++i) {
            int bs = fullBatchSize;
            if (i < nonFullBatches) {
                --bs;
            }
            ArrayList<Q> arrayList = new ArrayList<Q>(bs);
            for (int j = 0; j < bs; ++j) {
                arrayList.add(queryIt.next());
            }
            StaticQueriesJob job = new StaticQueriesJob(arrayList, (BatchProcessor)this.oracles.get(i + 1));
            Future<?> future = this.executor.submit(job);
            futures.add(future);
        }
        ArrayList<Q> localBatch = new ArrayList<Q>(fullBatchSize);
        for (int j = 0; j < fullBatchSize; ++j) {
            localBatch.add(queryIt.next());
        }
        this.processQueriesLocally(localBatch);
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (ExecutionException ex) {
            Throwables.throwIfUnchecked(ex.getCause());
            throw new AssertionError("Runnable must not throw checked exceptions", ex);
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
            throw new BatchInterruptedException(ex);
        }
    }

    private void processQueriesLocally(Collection<? extends Q> localBatch) {
        ((BatchProcessor)this.oracles.get(0)).processBatch(localBatch);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.executor.shutdownNow();
    }

    protected P getProcessor() {
        return (P)((BatchProcessor)this.oracles.get(0));
    }

    static {
        LearnLibSettings settings = LearnLibSettings.getInstance();
        int numCores = Runtime.getRuntime().availableProcessors();
        MIN_BATCH_SIZE = settings.getInt(LearnLibProperty.PARALLEL_BATCH_SIZE_STATIC, 10);
        NUM_INSTANCES = settings.getInt(LearnLibProperty.PARALLEL_POOL_SIZE, numCores);
        POOL_POLICY = settings.getEnumValue(LearnLibProperty.PARALLEL_POOL_SIZE, ThreadPool.PoolPolicy.class, ThreadPool.PoolPolicy.CACHED);
    }
}

