/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.parallelism;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.oracle.OmegaMembershipOracle;
import de.learnlib.oracle.membership.AbstractSULOmegaOracle;
import de.learnlib.oracle.membership.SULOracle;
import de.learnlib.oracle.membership.StateLocalInputSULOracle;
import de.learnlib.oracle.parallelism.DynamicParallelOmegaOracleBuilder;
import de.learnlib.oracle.parallelism.DynamicParallelOracleBuilder;
import de.learnlib.oracle.parallelism.StaticParallelOmegaOracleBuilder;
import de.learnlib.oracle.parallelism.StaticParallelOracleBuilder;
import de.learnlib.sul.ObservableSUL;
import de.learnlib.sul.SUL;
import de.learnlib.sul.StateLocalInputSUL;
import java.util.Collection;
import java.util.function.Supplier;
import net.automatalib.word.Word;

public final class ParallelOracleBuilders {
    private static final String FORKABLE_SUL_ERR = "SUL must be forkable for parallel processing";

    private ParallelOracleBuilders() {
    }

    public static <I, O> DynamicParallelOracleBuilder<I, Word<O>> newDynamicParallelOracle(SUL<I, O> sul) {
        Preconditions.checkArgument(sul.canFork(), FORKABLE_SUL_ERR);
        return new DynamicParallelOracleBuilder<I, O>(ParallelOracleBuilders.toSupplier(sul));
    }

    public static <I, O> DynamicParallelOracleBuilder<I, Word<O>> newDynamicParallelOracle(StateLocalInputSUL<I, O> sul, O undefinedInput) {
        Preconditions.checkArgument(sul.canFork(), FORKABLE_SUL_ERR);
        return new DynamicParallelOracleBuilder<I, O>(ParallelOracleBuilders.toSupplier(sul, undefinedInput));
    }

    public static <I, D> DynamicParallelOracleBuilder<I, D> newDynamicParallelOracle(Supplier<? extends MembershipOracle<I, D>> oracleSupplier) {
        return new DynamicParallelOracleBuilder(oracleSupplier);
    }

    @SafeVarargs
    public static <I, D> DynamicParallelOracleBuilder<I, D> newDynamicParallelOracle(MembershipOracle<I, D> firstOracle, MembershipOracle<I, D> ... otherOracles) {
        return ParallelOracleBuilders.newDynamicParallelOracle(Lists.asList(firstOracle, otherOracles));
    }

    public static <I, D> DynamicParallelOracleBuilder<I, D> newDynamicParallelOracle(Collection<? extends MembershipOracle<I, D>> oracles) {
        return new DynamicParallelOracleBuilder(oracles);
    }

    public static <I, O> DynamicParallelOmegaOracleBuilder<?, I, Word<O>> newDynamicParallelOmegaOracle(ObservableSUL<?, I, O> sul) {
        Preconditions.checkArgument(sul.canFork(), FORKABLE_SUL_ERR);
        return new DynamicParallelOmegaOracleBuilder(((Supplier<OmegaMembershipOracle<?, I, Word<O>>>)ParallelOracleBuilders.toSupplier(sul))::get);
    }

    public static <S, I, D> DynamicParallelOmegaOracleBuilder<S, I, D> newDynamicParallelOmegaOracle(Supplier<? extends OmegaMembershipOracle<S, I, D>> oracleSupplier) {
        return new DynamicParallelOmegaOracleBuilder(oracleSupplier);
    }

    @SafeVarargs
    public static <S, I, D> DynamicParallelOmegaOracleBuilder<S, I, D> newDynamicParallelOmegaOracle(OmegaMembershipOracle<S, I, D> firstOracle, OmegaMembershipOracle<S, I, D> ... otherOracles) {
        return ParallelOracleBuilders.newDynamicParallelOmegaOracle(Lists.asList(firstOracle, otherOracles));
    }

    public static <S, I, D> DynamicParallelOmegaOracleBuilder<S, I, D> newDynamicParallelOmegaOracle(Collection<? extends OmegaMembershipOracle<S, I, D>> oracles) {
        return new DynamicParallelOmegaOracleBuilder(oracles);
    }

    public static <I, O> StaticParallelOracleBuilder<I, Word<O>> newStaticParallelOracle(SUL<I, O> sul) {
        Preconditions.checkArgument(sul.canFork(), FORKABLE_SUL_ERR);
        return new StaticParallelOracleBuilder<I, O>(ParallelOracleBuilders.toSupplier(sul));
    }

    public static <I, O> StaticParallelOracleBuilder<I, Word<O>> newStaticParallelOracle(StateLocalInputSUL<I, O> sul, O undefinedInput) {
        Preconditions.checkArgument(sul.canFork(), FORKABLE_SUL_ERR);
        return new StaticParallelOracleBuilder<I, O>(ParallelOracleBuilders.toSupplier(sul, undefinedInput));
    }

    public static <I, D> StaticParallelOracleBuilder<I, D> newStaticParallelOracle(Supplier<? extends MembershipOracle<I, D>> oracleSupplier) {
        return new StaticParallelOracleBuilder(oracleSupplier);
    }

    @SafeVarargs
    public static <I, D> StaticParallelOracleBuilder<I, D> newStaticParallelOracle(MembershipOracle<I, D> firstOracle, MembershipOracle<I, D> ... otherOracles) {
        return ParallelOracleBuilders.newStaticParallelOracle(Lists.asList(firstOracle, otherOracles));
    }

    public static <I, D> StaticParallelOracleBuilder<I, D> newStaticParallelOracle(Collection<? extends MembershipOracle<I, D>> oracles) {
        return new StaticParallelOracleBuilder(oracles);
    }

    public static <I, O> StaticParallelOmegaOracleBuilder<?, I, Word<O>> newStaticParallelOmegaOracle(ObservableSUL<?, I, O> sul) {
        Preconditions.checkArgument(sul.canFork(), FORKABLE_SUL_ERR);
        return new StaticParallelOmegaOracleBuilder(((Supplier<OmegaMembershipOracle<?, I, Word<O>>>)ParallelOracleBuilders.toSupplier(sul))::get);
    }

    public static <S, I, D> StaticParallelOmegaOracleBuilder<S, I, D> newStaticParallelOmegaOracle(Supplier<? extends OmegaMembershipOracle<S, I, D>> oracleSupplier) {
        return new StaticParallelOmegaOracleBuilder(oracleSupplier);
    }

    @SafeVarargs
    public static <S, I, D> StaticParallelOmegaOracleBuilder<S, I, D> newStaticParallelOmegaOracle(OmegaMembershipOracle<S, I, D> firstOracle, OmegaMembershipOracle<S, I, D> ... otherOracles) {
        return ParallelOracleBuilders.newStaticParallelOmegaOracle(Lists.asList(firstOracle, otherOracles));
    }

    public static <S, I, D> StaticParallelOmegaOracleBuilder<S, I, D> newStaticParallelOmegaOracle(Collection<? extends OmegaMembershipOracle<S, I, D>> oracles) {
        return new StaticParallelOmegaOracleBuilder(oracles);
    }

    private static <I, O> Supplier<SULOracle<I, O>> toSupplier(SUL<I, O> sul) {
        return () -> new SULOracle(sul.fork());
    }

    private static <I, O> Supplier<StateLocalInputSULOracle<I, O>> toSupplier(StateLocalInputSUL<I, O> sul, O undefinedSymbol) {
        return () -> new StateLocalInputSULOracle(sul.fork(), undefinedSymbol);
    }

    private static <S, I, O> Supplier<OmegaMembershipOracle<?, I, Word<O>>> toSupplier(ObservableSUL<S, I, O> sul) {
        return () -> AbstractSULOmegaOracle.newOracle(sul.fork());
    }
}

