/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.util.moore;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.util.moore.MooreLearnerWrapper;
import de.learnlib.util.moore.SymbolOracleWrapper;
import java.util.Objects;
import net.automatalib.automaton.transducer.MooreMachine;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MooreUtil {
    public static final int NO_MISMATCH = -1;

    private MooreUtil() {
    }

    public static <O> int findMismatch(Word<O> out1, Word<O> out2) {
        int len = out1.length();
        assert (len == out2.length());
        for (int i = 0; i < len; ++i) {
            O sym2;
            O sym1 = out1.getSymbol(i);
            if (Objects.equals(sym1, sym2 = out2.getSymbol(i))) continue;
            return i;
        }
        return -1;
    }

    public static <I, O> @Nullable DefaultQuery<I, Word<O>> shortenCounterExample(MooreMachine<?, I, ?, O> hypothesis, DefaultQuery<I, Word<O>> ceQuery) {
        Word cePrefix = ceQuery.getPrefix();
        Word ceSuffix = ceQuery.getSuffix();
        Word hypOut = (Word)hypothesis.computeSuffixOutput(cePrefix, ceSuffix);
        Word<O> ceOut = ceQuery.getOutput();
        assert (ceOut.length() == hypOut.length());
        int mismatchIdx = MooreUtil.findMismatch(hypOut, ceOut);
        if (mismatchIdx == -1) {
            return null;
        }
        return new DefaultQuery(cePrefix, ceSuffix.prefix(mismatchIdx), ceOut.prefix(mismatchIdx + 1));
    }

    public static <I, O> @Nullable DefaultQuery<I, O> reduceCounterExample(MooreMachine<?, I, ?, O> hypothesis, DefaultQuery<I, Word<O>> ceQuery) {
        Word cePrefix = ceQuery.getPrefix();
        Word ceSuffix = ceQuery.getSuffix();
        Word hypOut = (Word)hypothesis.computeSuffixOutput(cePrefix, ceSuffix);
        Word<O> ceOut = ceQuery.getOutput();
        assert (ceOut.length() == hypOut.length());
        int mismatchIdx = MooreUtil.findMismatch(hypOut, ceOut);
        if (mismatchIdx == -1) {
            return null;
        }
        return new DefaultQuery(cePrefix, ceSuffix.prefix(mismatchIdx), ceOut.getSymbol(mismatchIdx));
    }

    public static <M extends MooreMachine<?, I, ?, O>, I, O> LearningAlgorithm.MooreLearner<I, O> wrapSymbolLearner(LearningAlgorithm<M, I, O> learner) {
        return new MooreLearnerWrapper<M, I, O>(learner);
    }

    public static <I, O> MembershipOracle<I, O> wrapWordOracle(MembershipOracle<I, Word<O>> oracle) {
        return new SymbolOracleWrapper<I, O>(oracle);
    }
}

