/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.layout.LayoutChangeListener;
import edu.uci.ics.jung.visualization.layout.LayoutEvent;
import edu.uci.ics.jung.visualization.layout.LayoutEventSupport;
import edu.uci.ics.jung.visualization.renderers.BasicVertexRenderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import java.awt.Shape;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CachingVertexRenderer<V, E>
extends BasicVertexRenderer<V, E>
implements ChangeListener,
LayoutChangeListener<V, E> {
    protected Map<V, Shape> vertexShapeMap = new HashMap<V, Shape>();
    protected Set<V> dirtyVertices = new HashSet<V>();

    public CachingVertexRenderer(BasicVisualizationServer<V, E> vv) {
        vv.getRenderContext().getMultiLayerTransformer().addChangeListener(this);
        Layout<V, E> layout = vv.getGraphLayout();
        if (layout instanceof LayoutEventSupport) {
            ((LayoutEventSupport)((Object)layout)).addLayoutChangeListener(this);
        }
    }

    @Override
    protected void paintIconForVertex(RenderContext<V, E> rc, V v, Layout<V, E> layout) {
        GraphicsDecorator g2 = rc.getGraphicsContext();
        boolean vertexHit = true;
        int[] coords = new int[2];
        Shape shape = this.vertexShapeMap.get(v);
        if (shape == null || this.dirtyVertices.contains(v)) {
            shape = this.prepareFinalVertexShape(rc, v, layout, coords);
            this.vertexShapeMap.put((Shape)v, shape);
            this.dirtyVertices.remove(v);
        }
        if (vertexHit = this.vertexHit(rc, shape)) {
            if (rc.getVertexIconTransformer() != null) {
                Icon icon = rc.getVertexIconTransformer().apply(v);
                if (icon != null) {
                    g2.draw(icon, rc.getScreenDevice(), shape, coords[0], coords[1]);
                } else {
                    this.paintShapeForVertex(rc, v, shape);
                }
            } else {
                this.paintShapeForVertex(rc, v, shape);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        System.err.println("got change event " + evt);
        this.vertexShapeMap.clear();
    }

    @Override
    public void layoutChanged(LayoutEvent<V, E> evt) {
        this.dirtyVertices.add(evt.getVertex());
    }
}

