/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.codegenerator;

import info.scce.addlib.codegenerator.CodeGenerator;
import info.scce.addlib.dd.DD;
import info.scce.addlib.dd.LabelledRegularDD;
import info.scce.addlib.dd.RegularDD;
import info.scce.addlib.traverser.PreorderTraverser;
import java.io.PrintWriter;
import java.util.List;

public class DotGenerator<D extends RegularDD<?, D>>
extends CodeGenerator<D> {
    private String paramGraphName = "ADDLibDecisionService";

    public DotGenerator<D> withGraphName(String gra) {
        this.paramGraphName = gra;
        return this;
    }

    @Override
    public void generate(PrintWriter out, List<LabelledRegularDD<D>> roots) {
        out.println("/* This file was generated with the ADD-Lib");
        out.println(" * http://add-lib.scce.info/ */");
        out.println();
        out.print("digraph \"");
        if (this.paramGraphName != null) {
            out.print(this.paramGraphName);
        }
        out.println("\" {");
        out.println();
        out.println("    bgcolor = transparent");
        out.print("    node [");
        this.nodeStyle(out);
        out.println("]");
        out.print("    edge [");
        this.edgeStyle(out);
        out.println("]");
        for (LabelledRegularDD<D> x0 : roots) {
            out.println();
            out.print("    \"f");
            out.print(((DD)x0.dd()).ptr());
            out.print("\" [");
            this.ddFunctionStyle(out, x0);
            out.print(", label = \"");
            out.print(x0.label());
            out.println("\"]");
            out.print("    \"f");
            out.print(((DD)x0.dd()).ptr());
            out.print("\" -> \"n");
            out.print(((DD)x0.dd()).ptr());
            out.print("\" [");
            this.ddFunctionThenStyle(out, x0);
            out.println("]");
        }
        for (RegularDD x1 : new PreorderTraverser<D>(this.unlabelledRoots(roots))) {
            if (x1.isConstant()) continue;
            out.println();
            out.print("    \"n");
            out.print(x1.ptr());
            out.print("\" [");
            this.internalDdStyle(out, x1);
            out.print(", label = \"");
            this.internalDdLabel(out, x1);
            out.println("\"]");
            out.print("    \"n");
            out.print(x1.ptr());
            out.print("\" -> \"n");
            out.print(((RegularDD)x1.e()).ptr());
            out.print("\" [");
            this.internalDdElseStyle(out, x1);
            out.println("]");
            out.print("    \"n");
            out.print(x1.ptr());
            out.print("\" -> \"n");
            out.print(((RegularDD)x1.t()).ptr());
            out.print("\" [");
            this.internalDdThenStyle(out, x1);
            out.println("]");
        }
        for (RegularDD x2 : new PreorderTraverser<D>(this.unlabelledRoots(roots))) {
            if (!x2.isConstant()) continue;
            out.println();
            out.print("    \"n");
            out.print(x2.ptr());
            out.print("\" [");
            this.constantDdStyle(out, x2);
            out.print(", label = \"");
            this.constantDdLabel(out, x2);
            out.println("\"]");
        }
        out.println("}");
    }

    protected void internalDdThenStyle(PrintWriter out, D x1) {
        out.print("style = solid");
    }

    protected void internalDdElseStyle(PrintWriter out, D x1) {
        out.print("style = dashed");
    }

    protected void ddFunctionStyle(PrintWriter out, LabelledRegularDD<D> x0) {
        out.print("fillcolor = lightgray, shape = rectangle");
    }

    protected void constantDdLabel(PrintWriter out, D x2) {
        out.print(((DD)x2).toString());
    }

    protected void ddFunctionThenStyle(PrintWriter out, LabelledRegularDD<D> x0) {
        out.print("style = solid");
    }

    protected void internalDdStyle(PrintWriter out, D x1) {
        out.print("fillcolor = white, shape = ellipse");
    }

    protected void edgeStyle(PrintWriter out) {
        out.print("arrowhead = none");
    }

    protected void nodeStyle(PrintWriter out) {
        out.print("style = filled, fontsize = 14, fontname = Arial");
    }

    protected void internalDdLabel(PrintWriter out, D x1) {
        out.print(((DD)x1).readName());
    }

    protected void constantDdStyle(PrintWriter out, D x2) {
        out.print("fillcolor = white, shape = rect");
    }
}

