/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd.bdd;

import info.scce.addlib.backend.BDDBackend;
import info.scce.addlib.backend.BackendProvider;
import info.scce.addlib.dd.DDManager;
import info.scce.addlib.dd.bdd.BDD;
import info.scce.addlib.parser.BDDLanguageLexer;
import info.scce.addlib.parser.BDDLanguageParser;
import info.scce.addlib.parser.BDDVisitor;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;

public class BDDManager
extends DDManager<BDD, BDDBackend> {
    public BDDManager() {
        this(BackendProvider.getBDDBackend());
    }

    public BDDManager(BDDBackend backend) {
        super(backend);
    }

    public BDD readOne() {
        long ddNodePtr = ((BDDBackend)this.getBackend()).readOne(this.ptr);
        return (BDD)new BDD(ddNodePtr, this).withRef();
    }

    public BDD readLogicZero() {
        long ddNodePtr = ((BDDBackend)this.getBackend()).readLogicZero(this.ptr);
        return (BDD)new BDD(ddNodePtr, this).withRef();
    }

    @Override
    public BDD namedVar(String name) {
        int i = this.varIdx(name);
        return this.backendIthVar(i);
    }

    public BDD namedVar(String name, BDD t, BDD e) {
        return this.ithVar(this.varIdx(name), t, e);
    }

    public BDD namedIthVar(String name, int i) {
        this.addVarName(name, i);
        return this.ithVar(i);
    }

    public BDD namedIthVar(String name, int i, BDD t, BDD e) {
        this.addVarName(name, i);
        return this.ithVar(i, t, e);
    }

    @Override
    public BDD ithVar(int var) {
        this.varName(var);
        return this.backendIthVar(var);
    }

    public BDD ithVar(int i, BDD t, BDD e) {
        BDD ithVar = this.ithVar(i);
        BDD result = ithVar.ite(t, e);
        ithVar.recursiveDeref();
        return result;
    }

    private BDD backendIthVar(int var) {
        long ddNodePtr = ((BDDBackend)this.getBackend()).ithVar(this.ptr, var);
        return (BDD)new BDD(ddNodePtr, this).withRef();
    }

    public BDD newVar() {
        long ddNodePtr = ((BDDBackend)this.getBackend()).newVar(this.ptr);
        BDD result = (BDD)new BDD(ddNodePtr, this).withRef();
        this.createVariableName(result);
        return result;
    }

    public BDD newVarAtLevel(int level) {
        long ddNodePtr = ((BDDBackend)this.getBackend()).newVarAtLevel(this.ptr, level);
        BDD result = (BDD)new BDD(ddNodePtr, this).withRef();
        this.createVariableName(result);
        return result;
    }

    @Override
    public BDD parse(String str) {
        ANTLRInputStream inputStream = new ANTLRInputStream(str);
        BDDLanguageLexer lexer = new BDDLanguageLexer(inputStream);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        BDDLanguageParser parser = new BDDLanguageParser(tokens);
        BDDVisitor ast = new BDDVisitor(this);
        return (BDD)ast.visit(parser.expr());
    }
}

