/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.traverser;

import info.scce.addlib.dd.DD;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class RecursiveTreeIterator<D extends DD<?, D>>
implements Iterator<D> {
    private final Iterator<D> roots;
    private final Stack<Call> callStack;
    private @Nullable D buffer;

    public RecursiveTreeIterator(D root) {
        this(Collections.singletonList(root));
    }

    public RecursiveTreeIterator(List<D> roots) {
        this.roots = roots.iterator();
        this.callStack = new Stack();
    }

    protected void pushDD(D dd) {
        Call call = new Call(this, dd);
        this.callStack.push(call);
    }

    protected D popDD() {
        return this.callStack.pop().dd();
    }

    @Override
    public boolean hasNext() {
        return this.fillBuffer() != null;
    }

    @Override
    public D next() {
        D bufferCpy = this.fillBuffer();
        if (bufferCpy == null) {
            throw new NoSuchElementException("The iteration has no more elements!");
        }
        this.buffer = null;
        return bufferCpy;
    }

    private @Nullable D fillBuffer() {
        while (this.buffer == null && (!this.callStack.isEmpty() || this.roots.hasNext())) {
            if (this.callStack.isEmpty()) {
                this.pushDD((DD)this.roots.next());
            }
            while (this.buffer == null && !this.callStack.isEmpty()) {
                Call top = this.callStack.peek();
                this.buffer = this.processDD(top.dd(), top.i());
                top.inc();
            }
        }
        return this.buffer;
    }

    protected abstract @Nullable D processDD(D var1, int var2);

    protected static class Call {
        private final D dd;
        private int i;
        final /* synthetic */ RecursiveTreeIterator this$0;

        public Call(D dd) {
            this.this$0 = this$0;
            this.dd = dd;
            this.i = 0;
        }

        public D dd() {
            return this.dd;
        }

        public int i() {
            return this.i;
        }

        public void inc() {
            ++this.i;
        }
    }
}

