/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.viewer;

import info.scce.addlib.dd.LabelledRegularDD;
import info.scce.addlib.dd.RegularDD;
import info.scce.addlib.viewer.DotViewerFrame;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;

public class DotViewer<D extends RegularDD<?, D>> {
    private static final String DEFAULT_VIEWER_NAME = "ADD-Lib Viewer";
    private final String viewerName;
    private final Lock lock = new ReentrantLock();
    private final Condition allFramesClosed = this.lock.newCondition();
    private final List<DotViewerFrame<D>> frames = new ArrayList<DotViewerFrame<D>>();

    public DotViewer() {
        this(DEFAULT_VIEWER_NAME);
    }

    public DotViewer(String viewerName) {
        this.viewerName = viewerName;
    }

    public void view(D root, String label) {
        this.view(new LabelledRegularDD<D>(root, label));
    }

    public void view(LabelledRegularDD<D> root) {
        this.view(Collections.singletonList(root));
    }

    public void view(List<LabelledRegularDD<D>> roots) {
        DotViewerFrame<D> f = new DotViewerFrame<D>(this.viewerName);
        f.view(roots);
        f.setVisible(true);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DotViewer.this.lock.lock();
                try {
                    DotViewer.this.frames.remove(e.getWindow());
                    if (DotViewer.this.frames.isEmpty()) {
                        DotViewer.this.allFramesClosed.signal();
                    }
                }
                finally {
                    DotViewer.this.lock.unlock();
                }
            }
        });
        this.lock.lock();
        try {
            this.frames.add(f);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilAllClosed() {
        this.lock.lock();
        try {
            DotViewer dotViewer = this;
            synchronized (dotViewer) {
                while (!this.frames.isEmpty()) {
                    this.allFramesClosed.await();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void closeAll() {
        this.lock.lock();
        try {
            for (Frame frame : this.frames) {
                SwingUtilities.invokeLater(() -> {
                    WindowEvent e = new WindowEvent(f, 201);
                    f.dispatchEvent(e);
                });
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

