/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.visualization;

import java.util.Map;
import net.automatalib.automaton.graph.TransitionEdge;
import net.automatalib.automaton.visualization.AutomatonVisualizationHelper;
import net.automatalib.ts.modal.ModalTransitionSystem;
import net.automatalib.ts.modal.transition.ModalEdgeProperty;

public class MTSVisualizationHelper<S, I, T, TP extends ModalEdgeProperty, M extends ModalTransitionSystem<S, I, T, TP>>
extends AutomatonVisualizationHelper<S, I, T, M> {
    public MTSVisualizationHelper(M mts) {
        super(mts);
    }

    @Override
    public boolean getEdgeProperties(S src, TransitionEdge<I, T> edge, S tgt, Map<String, String> properties) {
        super.getEdgeProperties(src, edge, tgt, properties);
        ModalEdgeProperty transitionProperty = (ModalEdgeProperty)((ModalTransitionSystem)this.automaton).getTransitionProperty(edge.getTransition());
        if (transitionProperty.isMayOnly()) {
            properties.put("style", "dashed");
        }
        properties.put("modality", transitionProperty.getModalType().name());
        return true;
    }
}

