/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.smartcollection;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ArrayStorage<T>
extends AbstractList<T>
implements RandomAccess,
Cloneable {
    private final @Nullable Object[] storage;

    public ArrayStorage(int size) {
        this.storage = new Object[size];
    }

    public ArrayStorage(int size, Supplier<T> supplier) {
        this.storage = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.storage[i] = supplier.get();
        }
    }

    public ArrayStorage(Collection<? extends T> collection) {
        this.storage = collection.toArray();
    }

    private ArrayStorage(@Nullable Object[] storage) {
        this.storage = storage;
    }

    @Override
    public T get(int index) {
        return (T)this.storage[index];
    }

    @Override
    public T set(int index, T element) {
        T oldValue = this.get(index);
        this.storage[index] = element;
        return oldValue;
    }

    @Override
    public int size() {
        return this.storage.length;
    }

    public ArrayStorage<T> clone() {
        return new ArrayStorage<T>((Object[])this.storage.clone());
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayStorage)) {
            return false;
        }
        ArrayStorage that = (ArrayStorage)o;
        return Arrays.equals(this.storage, that.storage);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.storage);
    }
}

