/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.util;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPInputStream;
import net.automatalib.common.util.io.NonClosingInputStream;
import net.automatalib.common.util.io.NonClosingOutputStream;

public final class IOUtil {
    private IOUtil() {
    }

    public static InputStream asUncompressedInputStream(InputStream is) throws IOException {
        int bytesRead;
        Preconditions.checkArgument(is.markSupported(), "input stream must support marking");
        is.mark(2);
        byte[] buf = new byte[2];
        try {
            bytesRead = is.read(buf);
        }
        finally {
            is.reset();
        }
        if (bytesRead == 2) {
            int byteMask = 255;
            int byteWidth = 8;
            int magic = (buf[1] & 0xFF) << 8 | buf[0] & 0xFF;
            if (magic == 35615) {
                return new GZIPInputStream(is);
            }
        }
        return is;
    }

    public static InputStream asBufferedInputStream(InputStream is) {
        if (IOUtil.isBufferedInputStream(is)) {
            return is;
        }
        return new BufferedInputStream(is);
    }

    public static InputStream asBufferedInputStream(File file) throws IOException {
        return IOUtil.asBufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public static OutputStream asBufferedOutputStream(OutputStream os) {
        if (IOUtil.isBufferedOutputStream(os)) {
            return os;
        }
        return new BufferedOutputStream(os);
    }

    public static OutputStream asBufferedOutputStream(File file) throws IOException {
        return IOUtil.asBufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
    }

    public static Reader asBufferedUTF8Reader(File file) throws IOException {
        return Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);
    }

    public static Reader asBufferedUTF8Reader(InputStream is) {
        return IOUtil.asUTF8Reader(IOUtil.asBufferedInputStream(is));
    }

    public static Reader asUTF8Reader(InputStream is) {
        return new InputStreamReader(is, StandardCharsets.UTF_8);
    }

    public static Writer asBufferedUTF8Writer(File file) throws IOException {
        return Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static Writer asBufferedUTF8Writer(OutputStream os) {
        return IOUtil.asUTF8Writer(IOUtil.asBufferedOutputStream(os));
    }

    public static Writer asUTF8Writer(OutputStream os) {
        return new OutputStreamWriter(os, StandardCharsets.UTF_8);
    }

    public static InputStream asUncompressedBufferedNonClosingInputStream(InputStream is) throws IOException {
        if (IOUtil.isBufferedInputStream(is)) {
            return IOUtil.asUncompressedInputStream(new NonClosingInputStream(is));
        }
        return IOUtil.asUncompressedInputStream(IOUtil.asBufferedInputStream(new NonClosingInputStream(is)));
    }

    public static Reader asUncompressedBufferedNonClosingUTF8Reader(InputStream is) throws IOException {
        return IOUtil.asUTF8Reader(IOUtil.asUncompressedBufferedNonClosingInputStream(is));
    }

    public static OutputStream asBufferedNonClosingOutputStream(OutputStream os) {
        if (IOUtil.isBufferedOutputStream(os)) {
            return new NonClosingOutputStream(os);
        }
        return IOUtil.asBufferedOutputStream(new NonClosingOutputStream(os));
    }

    public static Writer asBufferedNonClosingUTF8Writer(OutputStream os) {
        return IOUtil.asUTF8Writer(IOUtil.asBufferedNonClosingOutputStream(os));
    }

    private static boolean isBufferedInputStream(InputStream is) {
        return is instanceof BufferedInputStream || is instanceof ByteArrayInputStream;
    }

    private static boolean isBufferedOutputStream(OutputStream os) {
        return os instanceof BufferedOutputStream || os instanceof ByteArrayOutputStream;
    }
}

