/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.util.fixpoint;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.automatalib.common.util.Pair;
import net.automatalib.common.util.fixpoint.WorksetAlgorithm;
import net.automatalib.common.util.fixpoint.WorksetMappingAlgorithm;

public final class Worksets {
    private Worksets() {
    }

    public static <T, R> R process(WorksetAlgorithm<T, R> algorithm) {
        int expectedElementCount = algorithm.expectedElementCount();
        ArrayDeque<T> queue = new ArrayDeque<T>(expectedElementCount);
        HashSet<T> tracking = Sets.newHashSetWithExpectedSize(expectedElementCount);
        Collection<T> initialElements = algorithm.initialize();
        queue.addAll(initialElements);
        tracking.addAll(initialElements);
        while (!queue.isEmpty()) {
            Object current = queue.remove();
            tracking.remove(current);
            Collection<T> discovered = algorithm.update(current);
            for (T element : discovered) {
                if (!tracking.add(element)) continue;
                queue.add(element);
            }
        }
        return algorithm.result();
    }

    public static <T, E, R> Pair<Map<T, E>, R> map(WorksetMappingAlgorithm<T, E, R> algorithm) {
        ArrayDeque<T> queue = new ArrayDeque<T>(algorithm.expectedElementCount());
        HashSet<T> tracking = Sets.newHashSetWithExpectedSize(algorithm.expectedElementCount());
        HashMap mapping = Maps.newHashMapWithExpectedSize(algorithm.expectedElementCount());
        Collection<T> initialElements = algorithm.initialize(mapping);
        queue.addAll(initialElements);
        tracking.addAll(initialElements);
        while (!queue.isEmpty()) {
            Object currentT = queue.remove();
            tracking.remove(currentT);
            Collection<T> discovered = algorithm.update(mapping, currentT);
            for (T element : discovered) {
                if (!tracking.add(element)) continue;
                queue.add(element);
            }
        }
        return Pair.of(mapping, algorithm.result());
    }
}

