/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.util.random;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class RandomUtil {
    private RandomUtil() {
    }

    public static <T> @Nullable T choose(Random rand, T[] array) {
        int len = array.length;
        if (len == 0) {
            return null;
        }
        int idx = rand.nextInt(array.length);
        return array[idx];
    }

    public static <T> @Nullable T choose(Random rand, List<? extends T> list) {
        int size = list.size();
        if (size == 0) {
            return null;
        }
        int idx = rand.nextInt(size);
        return list.get(idx);
    }

    public static int[] distinctIntegers(Random rand, int num, int min2, int max) {
        int range = max - min2;
        int size = Math.min(num, range);
        int[] result = new int[size];
        BitSet cache = new BitSet(range);
        int idx = 0;
        for (int j = range - size; j < range; ++j) {
            int t = rand.nextInt(j + 1);
            int elem = cache.get(t) ? j : t;
            cache.set(elem);
            result[idx++] = elem + min2;
        }
        return result;
    }

    public static int[] distinctIntegers(Random rand, int num, int max) {
        return RandomUtil.distinctIntegers(rand, num, 0, max);
    }

    public static <T> List<T> sample(Random rand, List<? extends T> list, int num) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(num);
        int size = list.size();
        for (int i = 0; i < num; ++i) {
            int idx = rand.nextInt(size);
            result.add(list.get(idx));
        }
        return result;
    }

    public static <T> List<T> sampleUnique(Random rand, List<? extends T> list, int num) {
        int elems = list.size();
        if (elems == 0) {
            return Collections.emptyList();
        }
        int[] indices = RandomUtil.distinctIntegers(rand, num, elems);
        ArrayList<T> result = new ArrayList<T>(indices.length);
        for (int index : indices) {
            result.add(list.get(index));
        }
        return result;
    }
}

