/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.util.string;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.regex.Pattern;
import net.automatalib.common.util.string.Printable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringUtil.class);

    private StringUtil() {
    }

    public static String enquote(String s2) {
        StringBuilder sb = new StringBuilder(s2.length() + 2);
        try {
            StringUtil.enquote(s2, sb);
        }
        catch (IOException e) {
            LOGGER.error("Could not enquote String", e);
        }
        return sb.toString();
    }

    public static void enquote(String s2, Appendable a) throws IOException {
        a.append('\"');
        StringUtil.escapeQuotes(s2, a);
        a.append('\"');
    }

    public static Pattern getIdentifierPattern() {
        return LazyPatternHolder.INSTANCE;
    }

    public static String enquoteIfNecessary(String s2) {
        StringBuilder sb = new StringBuilder();
        try {
            StringUtil.enquoteIfNecessary(s2, sb);
            return sb.toString();
        }
        catch (IOException ex) {
            throw new AssertionError("StringBuilder should not throw", ex);
        }
    }

    public static void enquoteIfNecessary(String s2, Appendable a) throws IOException {
        StringUtil.enquoteIfNecessary(s2, a, StringUtil.getIdentifierPattern());
    }

    public static String enquoteIfNecessary(String s2, Pattern p) {
        StringBuilder sb = new StringBuilder();
        try {
            StringUtil.enquoteIfNecessary(s2, sb, p);
            return sb.toString();
        }
        catch (IOException ex) {
            throw new AssertionError("StringBuilder should not throw", ex);
        }
    }

    public static void enquoteIfNecessary(String s2, Appendable a, Pattern valid) throws IOException {
        if (!valid.matcher(s2).matches()) {
            StringUtil.enquote(s2, a);
        } else {
            a.append(s2);
        }
    }

    public static void enquoteIfNecessary(String s2, Appendable a, Pattern valid, Pattern exception) throws IOException {
        if (!valid.matcher(s2).matches() || exception.matcher(s2).matches()) {
            StringUtil.enquote(s2, a);
        } else {
            a.append(s2);
        }
    }

    public static String unquote(String s2) {
        if (s2.length() < 2) {
            throw new IllegalArgumentException("Argument to StringUtil.unquote() must begin and end with a double quote ('\"').");
        }
        StringBuilder sb = new StringBuilder(s2.length() - 2);
        try {
            StringUtil.unquote(s2, sb);
        }
        catch (IOException e) {
            LOGGER.error("Could not unquote String", e);
        }
        return sb.toString();
    }

    public static void unquote(String s2, Appendable a) throws IOException {
        if (s2.charAt(0) != '\"' || s2.charAt(s2.length() - 1) != '\"') {
            throw new IllegalArgumentException("Argument to StringUtil.unquote() must begin and end with a double quote ('\"').");
        }
        StringUtil.unescapeQuotes(s2.substring(1, s2.length() - 1), a);
    }

    public static String unescapeQuotes(String s2) {
        StringBuilder sb = new StringBuilder(s2.length());
        try {
            StringUtil.unescapeQuotes(s2, sb);
        }
        catch (IOException e) {
            LOGGER.error("Could not unescape quotes", e);
        }
        return sb.toString();
    }

    public static void unescapeQuotes(String s2, Appendable a) throws IOException {
        int idx;
        if (s2.isEmpty()) {
            return;
        }
        int eos = s2.length() - 1;
        for (idx = 0; idx < eos; ++idx) {
            char c = s2.charAt(idx);
            if (c == '\\' && (c = s2.charAt(++idx)) != '\"' && c != '\\') {
                a.append('\\');
            }
            a.append(c);
        }
        if (idx < s2.length()) {
            a.append(s2.charAt(eos));
        }
    }

    public static String escapeQuotes(String s2) {
        StringBuilder sb = new StringBuilder(s2.length());
        try {
            StringUtil.escapeQuotes(s2, sb);
        }
        catch (IOException e) {
            LOGGER.error("Could not escape quotes", e);
        }
        return sb.toString();
    }

    public static void escapeQuotes(String s2, Appendable a) throws IOException {
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c == '\\' || c == '\"') {
                a.append('\\');
            }
            a.append(c);
        }
    }

    public static void appendArray(Appendable a, Object[] array, String sepString) throws IOException {
        StringUtil.appendIterable(a, () -> Iterators.forArray(array), sepString);
    }

    public static void appendArrayEnquoted(Appendable a, Object[] array, String sepString) throws IOException {
        StringUtil.appendIterableEnquoted(a, () -> Iterators.forArray(array), sepString);
    }

    public static void appendIterable(Appendable a, Iterable<?> it, String sepString) throws IOException {
        boolean first = true;
        for (Object o : it) {
            if (first) {
                first = false;
            } else {
                a.append(sepString);
            }
            StringUtil.appendObject(a, o);
        }
    }

    public static void appendIterableEnquoted(Appendable a, Iterable<?> it, String sepString) throws IOException {
        boolean first = true;
        for (Object o : it) {
            if (first) {
                first = false;
            } else {
                a.append(sepString);
            }
            StringUtil.enquote(String.valueOf(o), a);
        }
    }

    public static void appendObject(Appendable a, @Nullable Object obj) throws IOException {
        if (obj instanceof Printable) {
            ((Printable)obj).print(a);
        } else {
            a.append(String.valueOf(obj));
        }
    }

    private static class LazyPatternHolder {
        private static final Pattern INSTANCE = Pattern.compile("[a-zA-Z_]*\\w*");

        private LazyPatternHolder() {
        }
    }
}

