/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graph.helper;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.automatalib.graph.SimpleGraph;
import net.automatalib.graph.concept.NodeIDs;

public class SimpleNodeIDs<N>
implements NodeIDs<N> {
    private final Map<N, Integer> nodeIds;
    private final List<N> nodes;

    public SimpleNodeIDs(SimpleGraph<N> graph) {
        this.nodes = new ArrayList<N>(graph.getNodes());
        int numNodes = this.nodes.size();
        this.nodeIds = Maps.newHashMapWithExpectedSize(numNodes);
        for (int i = 0; i < numNodes; ++i) {
            N node = this.nodes.get(i);
            this.nodeIds.put(node, i);
        }
    }

    @Override
    public int getNodeId(N node) {
        Integer id = this.nodeIds.get(node);
        if (id == null) {
            throw new IllegalArgumentException();
        }
        return id;
    }

    @Override
    public N getNode(int id) {
        if (id < 0 || id >= this.nodes.size()) {
            throw new IllegalArgumentException();
        }
        return this.nodes.get(id);
    }
}

