/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.ltsmin;

import java.io.StringReader;
import net.automatalib.modelchecker.ltsmin.InternalLTSminLTLParser;
import net.automatalib.modelchecker.ltsmin.ParseException;
import net.automatalib.modelchecker.ltsmin.TokenMgrError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LTSminLTLParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(LTSminLTLParser.class);

    private LTSminLTLParser() {
    }

    public static String requireValidLetterFormula(String formula) {
        InternalLTSminLTLParser parser = new InternalLTSminLTLParser(new StringReader(formula));
        try {
            parser.letterFormula();
        }
        catch (ParseException | TokenMgrError e) {
            throw new IllegalArgumentException("Given formula does not adhere to expected format", e);
        }
        return formula;
    }

    public static boolean isValidLetterFormula(String formula) {
        try {
            LTSminLTLParser.requireValidLetterFormula(formula);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.debug("Couldn't parse formula", iae);
            return false;
        }
        return true;
    }

    public static String requireValidIOFormula(String formula) {
        InternalLTSminLTLParser parser = new InternalLTSminLTLParser(new StringReader(formula));
        try {
            parser.ioFormula();
        }
        catch (ParseException | TokenMgrError e) {
            throw new IllegalArgumentException("Given formula does not adhere to expected format", e);
        }
        return formula;
    }

    public static boolean isValidIOFormula(String formula) {
        try {
            LTSminLTLParser.requireValidIOFormula(formula);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.debug("Couldn't parse formula", iae);
            return false;
        }
        return true;
    }
}

