/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.transformer;

import info.scce.addlib.dd.bdd.BDD;
import info.scce.addlib.dd.bdd.BDDManager;
import info.scce.addlib.dd.xdd.XDD;
import info.scce.addlib.dd.xdd.latticedd.example.BooleanLogicDDManager;
import info.scce.addlib.serializer.DDProperty;
import info.scce.addlib.serializer.XDDSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.automatalib.modelchecker.m3c.transformer.BDDTransformer;
import net.automatalib.modelchecker.m3c.transformer.TransformerSerializer;

public class BDDTransformerSerializer<L, AP>
implements TransformerSerializer<BDDTransformer<L, AP>, L, AP> {
    private final BDDManager bddManager;

    public BDDTransformerSerializer(BDDManager bddManager) {
        this.bddManager = bddManager;
    }

    @Override
    public List<String> serialize(BDDTransformer<L, AP> transformer) {
        XDDSerializer xddSerializer = new XDDSerializer();
        ArrayList<String> serializedBDDs = new ArrayList<String>();
        BooleanLogicDDManager ddManager = new BooleanLogicDDManager();
        for (int i = 0; i < transformer.getNumberOfVars(); ++i) {
            XDD<Boolean> bddAsXDD = transformer.getBDD(i).toXDD(ddManager);
            serializedBDDs.add(xddSerializer.serialize(bddAsXDD));
        }
        ddManager.quit();
        return serializedBDDs;
    }

    @Override
    public BDDTransformer<L, AP> deserialize(List<String> data) {
        BooleanLogicDDManager ddManager = new BooleanLogicDDManager();
        XDDSerializer serializer = new XDDSerializer();
        ArrayList<XDD> xdds = new ArrayList<XDD>();
        for (String serializedDD : data) {
            xdds.add((XDD)serializer.deserialize(ddManager, serializedDD, DDProperty.VARNAMEANDVARINDEX));
        }
        BDD[] bdds = new BDD[xdds.size()];
        for (int i = 0; i < bdds.length; ++i) {
            bdds[i] = this.toBDD((XDD)xdds.get(i), this.bddManager, new HashMap<XDD<Boolean>, BDD>());
        }
        ddManager.quit();
        return new BDDTransformer(this.bddManager, bdds);
    }

    private BDD toBDD(XDD<Boolean> xdd, BDDManager bddManager, Map<XDD<Boolean>, BDD> xdd2bdd) {
        BDD bdd = xdd2bdd.get(xdd);
        if (bdd == null) {
            if (xdd.isConstant()) {
                bdd = xdd.v().booleanValue() ? bddManager.readOne() : bddManager.readLogicZero();
            } else {
                BDD falseSucc = this.toBDD((XDD<Boolean>)xdd.e(), bddManager, xdd2bdd);
                BDD trueSucc = this.toBDD((XDD<Boolean>)xdd.t(), bddManager, xdd2bdd);
                BDD ithBDD = bddManager.ithVar(bddManager.varIdx(xdd.readName()));
                bdd = ithBDD.ite(trueSucc, falseSucc);
            }
            xdd2bdd.put(xdd, bdd);
        }
        return bdd;
    }
}

