/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.transducer;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.CompactMealy;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.automaton.transducer.MutableMealyMachine;
import net.automatalib.common.util.mapping.Mapping;
import net.automatalib.ts.TransitionPredicate;
import net.automatalib.util.automaton.copy.AutomatonCopyMethod;
import net.automatalib.util.automaton.copy.AutomatonLowLevelCopy;
import net.automatalib.util.automaton.predicate.TransitionPredicates;

public final class MealyFilter {
    private MealyFilter() {
    }

    @SafeVarargs
    public static <I, O> CompactMealy<I, O> pruneTransitionsWithOutput(MealyMachine<?, I, ?, O> in, Alphabet<I> inputs, O ... outputs) {
        return MealyFilter.pruneTransitionsWithOutput(in, inputs, Arrays.asList(outputs));
    }

    public static <I, O> CompactMealy<I, O> pruneTransitionsWithOutput(MealyMachine<?, I, ?, O> in, Alphabet<I> inputs, Collection<? super O> outputs) {
        return MealyFilter.filterByOutput(in, inputs, o -> !outputs.contains(o));
    }

    public static <I, O> CompactMealy<I, O> filterByOutput(MealyMachine<?, I, ?, O> in, Alphabet<I> inputs, Predicate<? super O> outputPred) {
        CompactMealy out = new CompactMealy(inputs);
        MealyFilter.filterByOutput(in, inputs, out, outputPred);
        return out;
    }

    public static <S1, T1, S2, I, O> Mapping<S1, S2> filterByOutput(MealyMachine<S1, I, T1, O> in, Collection<? extends I> inputs, MutableMealyMachine<S2, I, ?, O> out, Predicate<? super O> outputPred) {
        TransitionPredicate transPred = TransitionPredicates.outputSatisfies(in, outputPred);
        return AutomatonLowLevelCopy.copy(AutomatonCopyMethod.DFS, in, inputs, out, s2 -> true, transPred);
    }

    @SafeVarargs
    public static <I, O> CompactMealy<I, O> retainTransitionsWithOutput(MealyMachine<?, I, ?, O> in, Alphabet<I> inputs, O ... outputs) {
        return MealyFilter.retainTransitionsWithOutput(in, inputs, Arrays.asList(outputs));
    }

    public static <I, O> CompactMealy<I, O> retainTransitionsWithOutput(MealyMachine<?, I, ?, O> in, Alphabet<I> inputs, Collection<? super O> outputs) {
        return MealyFilter.filterByOutput(in, inputs, outputs::contains);
    }
}

