/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.ts.traversal;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.ts.TransitionSystem;
import net.automatalib.util.traversal.VisitedState;
import net.automatalib.util.ts.traversal.SimpleDFRecord;
import org.checkerframework.checker.nullness.qual.Nullable;

final class DepthFirstIterator<S, I, T>
extends AbstractIterator<S> {
    private final MutableMapping<S, @Nullable VisitedState> visited;
    private final Deque<SimpleDFRecord<S, I, T>> dfsStack = new ArrayDeque<SimpleDFRecord<S, I, T>>();
    private final TransitionSystem<S, I, T> ts;
    private final Collection<? extends I> inputs;

    DepthFirstIterator(TransitionSystem<S, I, T> ts, Collection<? extends I> inputs) {
        this.ts = ts;
        this.inputs = inputs;
        this.visited = ts.createStaticStateMapping();
        for (Object init : ts.getInitialStates()) {
            this.dfsStack.push(new SimpleDFRecord(init, inputs));
        }
    }

    @Override
    protected S computeNext() {
        SimpleDFRecord<S, I, T> rec;
        while ((rec = this.dfsStack.peek()) != null) {
            if (!rec.wasStarted()) {
                this.visited.put(rec.state, VisitedState.VISITED);
                rec.start(this.ts);
                return rec.state;
            }
            if (rec.hasNextTransition(this.ts)) {
                T t = rec.transition();
                S succ = this.ts.getSuccessor(t);
                if (this.visited.get(succ) == VisitedState.VISITED) continue;
                this.dfsStack.push(new SimpleDFRecord(succ, this.inputs));
                continue;
            }
            this.dfsStack.pop();
        }
        return (S)this.endOfData();
    }
}

