/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.acex;

import de.learnlib.acex.AbstractCounterexample;

public final class AcexAnalysisAlgorithms {
    private AcexAnalysisAlgorithms() {
    }

    public static <E> int linearSearchFwd(AbstractCounterexample<E> acex, int low, int high) {
        assert (!acex.testEffects(low, high));
        E effPrev = acex.effect(low);
        for (int i = low + 1; i <= high; ++i) {
            E eff = acex.effect(i);
            if (!acex.checkEffects(effPrev, eff)) {
                return i - 1;
            }
            effPrev = eff;
        }
        throw new IllegalArgumentException();
    }

    public static <E> int linearSearchBwd(AbstractCounterexample<E> acex, int low, int high) {
        assert (!acex.testEffects(low, high));
        E effPrev = acex.effect(high);
        for (int i = high - 1; i >= low; --i) {
            E eff = acex.effect(i);
            if (!acex.checkEffects(eff, effPrev)) {
                return i;
            }
            effPrev = eff;
        }
        throw new IllegalArgumentException();
    }

    public static <E> int exponentialSearchBwd(AbstractCounterexample<E> acex, int low, int high) {
        assert (!acex.testEffects(low, high));
        int ofs = 1;
        E effHigh = acex.effect(high);
        int highIter = high;
        int lowIter = low;
        while (highIter - ofs > lowIter) {
            int next = highIter - ofs;
            E eff = acex.effect(next);
            if (!acex.checkEffects(eff, effHigh)) {
                lowIter = next;
                break;
            }
            highIter = next;
            ofs *= 2;
        }
        return AcexAnalysisAlgorithms.binarySearchRight(acex, lowIter, highIter);
    }

    public static <E> int binarySearchRight(AbstractCounterexample<E> acex, int low, int high) {
        E effLow = acex.effect(low);
        E effHigh = acex.effect(high);
        assert (!acex.checkEffects(effLow, effHigh)) : "compatible effects at " + low + ", " + high + ": " + effLow + ", " + effHigh;
        int highIter = high;
        int lowIter = low;
        while (highIter - lowIter > 1) {
            int mid = lowIter + (highIter - lowIter) / 2;
            E effMid = acex.effect(mid);
            if (!acex.checkEffects(effMid, effHigh)) {
                lowIter = mid;
                continue;
            }
            highIter = mid;
            effHigh = effMid;
        }
        return lowIter;
    }

    public static <E> int exponentialSearchFwd(AbstractCounterexample<E> acex, int low, int high) {
        int next;
        E eff;
        assert (!acex.testEffects(low, high));
        int ofs = 1;
        E effLow = acex.effect(low);
        int lowIter = low;
        while (lowIter + ofs < high && acex.checkEffects(effLow, eff = acex.effect(next = lowIter + ofs))) {
            lowIter = next;
            ofs *= 2;
        }
        return AcexAnalysisAlgorithms.binarySearchLeft(acex, lowIter, high);
    }

    public static <E> int binarySearchLeft(AbstractCounterexample<E> acex, int low, int high) {
        E effLow = acex.effect(low);
        E effHigh = acex.effect(high);
        assert (!acex.checkEffects(effLow, effHigh)) : "compatible effects at " + low + ", " + high + ": " + effLow + ", " + effHigh;
        int highIter = high;
        int lowIter = low;
        while (highIter - lowIter > 1) {
            int mid = lowIter + (highIter - lowIter) / 2;
            E effMid = acex.effect(mid);
            if (!acex.checkEffects(effLow, effMid)) {
                highIter = mid;
                continue;
            }
            lowIter = mid;
            effLow = effMid;
        }
        return lowIter;
    }
}

