/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.aaar;

import de.learnlib.algorithm.LearnerConstructor;
import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.aaar.abstraction.AbstractAbstractionTree;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.GrowingAlphabet;
import net.automatalib.alphabet.GrowingMapAlphabet;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.MutableDeterministic;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

public abstract class AbstractAAARLearner<L extends LearningAlgorithm<CM, CI, D> & SupportsGrowingAlphabet<CI>, AM, CM, AI, CI, D>
implements LearningAlgorithm<AM, CI, D> {
    private final L learner;
    private final MembershipOracle<CI, D> oracle;
    private final GrowingAlphabet<CI> rep;
    private final GrowingAlphabet<AI> abs;

    public AbstractAAARLearner(LearnerConstructor<L, CI, D> learnerConstructor, MembershipOracle<CI, D> o) {
        this.oracle = o;
        this.rep = new GrowingMapAlphabet<CI>();
        this.abs = new GrowingMapAlphabet<AI>();
        this.learner = learnerConstructor.constructLearner(this.rep, this.oracle);
    }

    @Override
    public void startLearning() {
        for (AI ai : this.getInitialAbstracts()) {
            this.abs.addSymbol(ai);
        }
        for (Object ci : this.getInitialRepresentatives()) {
            this.rep.addSymbol(ci);
            ((SupportsGrowingAlphabet)this.learner).addAlphabetSymbol(ci);
        }
        this.learner.startLearning();
    }

    @Override
    public boolean refineHypothesis(DefaultQuery<CI, D> query) {
        Word input = query.getInput();
        WordBuilder wb = new WordBuilder(input.size());
        Word prefix = Word.epsilon();
        for (int i = 0; i < input.size(); ++i) {
            D outNew;
            Object cur = input.getSymbol(i);
            AbstractAbstractionTree tree = this.getTreeForRepresentative(cur);
            AI a = tree.getAbstractSymbol(cur);
            Object r = tree.getRepresentative(a);
            Word suffix = input.suffix(input.size() - i - 1);
            Word testOld = prefix.append(r).concat(suffix);
            Word testNew = prefix.append(cur).concat(suffix);
            D outOld = this.oracle.answerQuery(testOld);
            if (!Objects.equals(outOld, outNew = this.oracle.answerQuery(testNew))) {
                AI newA = tree.splitLeaf(r, cur, prefix, suffix, outOld);
                this.abs.addSymbol(newA);
                this.rep.addSymbol(cur);
                ((SupportsGrowingAlphabet)this.learner).addAlphabetSymbol(cur);
                return true;
            }
            prefix = prefix.append(r);
            wb.append(r);
        }
        int prefixLen = query.getPrefix().length();
        DefaultQuery concreteCE = new DefaultQuery(wb.toWord(0, prefixLen), wb.toWord(prefixLen, wb.size()), query.getOutput());
        return this.learner.refineHypothesis(concreteCE);
    }

    public Alphabet<AI> getAbstractAlphabet() {
        return this.abs;
    }

    public abstract Alphabet<CI> getLearnerAlphabet();

    public CM getLearnerHypothesisModel() {
        return (CM)this.learner.getHypothesisModel();
    }

    public abstract CM getTranslatingHypothesisModel();

    public L getLearner() {
        return this.learner;
    }

    protected <S1, S2, SP, TP> void copyAbstract(UniversalDeterministicAutomaton<S1, CI, ?, SP, TP> src, MutableDeterministic<S2, AI, ?, SP, TP> tgt) {
        HashMap states = new HashMap();
        HashMap statesRev = new HashMap();
        for (Object s2 : src.getStates()) {
            Object sp = src.getStateProperty(s2);
            Object n = tgt.addState(sp);
            tgt.setInitial(n, Objects.equals(s2, src.getInitialState()));
            states.put(n, s2);
            statesRev.put(s2, n);
        }
        for (Map.Entry entry : states.entrySet()) {
            for (Object r : this.rep) {
                AbstractAbstractionTree tree = this.getTreeForRepresentative(r);
                AI a = tree.getAbstractSymbol(r);
                tgt.setTransition(entry.getKey(), a, statesRev.get(src.getSuccessor(entry.getValue(), r)), src.getTransitionProperty(entry.getValue(), r));
            }
        }
    }

    protected abstract AbstractAbstractionTree<AI, CI, D> getTreeForRepresentative(CI var1);

    protected abstract Collection<AI> getInitialAbstracts();

    protected abstract Collection<CI> getInitialRepresentatives();
}

