/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.aaar.explicit;

import com.google.common.collect.Maps;
import de.learnlib.algorithm.LearnerConstructor;
import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.aaar.AbstractAAARLearner;
import de.learnlib.algorithm.aaar.ExplicitInitialAbstraction;
import de.learnlib.algorithm.aaar.abstraction.AbstractAbstractionTree;
import de.learnlib.algorithm.aaar.abstraction.ExplicitAbstractionTree;
import de.learnlib.oracle.MembershipOracle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.alphabet.SupportsGrowingAlphabet;

public abstract class AbstractExplicitAAARLearner<L extends LearningAlgorithm<CM, CI, D> & SupportsGrowingAlphabet<CI>, AM, CM, AI, CI, D>
extends AbstractAAARLearner<L, AM, CM, AI, CI, D> {
    private final ExplicitInitialAbstraction<AI, CI> explicitInitialAbstraction;
    private final Map<AI, ExplicitAbstractionTree<AI, CI, D>> trees;

    public AbstractExplicitAAARLearner(LearnerConstructor<L, CI, D> learnerConstructor, MembershipOracle<CI, D> oracle, ExplicitInitialAbstraction<AI, CI> explicitInitialAbstraction, Function<AI, AI> incrementor) {
        super(learnerConstructor, oracle);
        this.explicitInitialAbstraction = explicitInitialAbstraction;
        this.trees = Maps.newHashMapWithExpectedSize(explicitInitialAbstraction.getInitialAbstracts().size());
        for (AI a : explicitInitialAbstraction.getInitialAbstracts()) {
            Object rep = explicitInitialAbstraction.getRepresentative(a);
            this.trees.put(a, new ExplicitAbstractionTree(a, rep, oracle, incrementor));
        }
    }

    @Override
    public Alphabet<CI> getLearnerAlphabet() {
        HashSet symbols = new HashSet();
        for (AbstractAbstractionTree abstractAbstractionTree : this.trees.values()) {
            symbols.addAll(abstractAbstractionTree.getRepresentativeSymbols());
        }
        return Alphabets.fromCollection(symbols);
    }

    @Override
    protected AbstractAbstractionTree<AI, CI, D> getTreeForRepresentative(CI ci) {
        AbstractAbstractionTree tree = this.trees.get(this.explicitInitialAbstraction.getAbstractSymbol(ci));
        assert (tree != null);
        return tree;
    }

    @Override
    protected Collection<AI> getInitialAbstracts() {
        return this.explicitInitialAbstraction.getInitialAbstracts();
    }

    @Override
    protected Collection<CI> getInitialRepresentatives() {
        Collection<AI> abs = this.explicitInitialAbstraction.getInitialAbstracts();
        ArrayList rep = new ArrayList(abs.size());
        for (AI ai : abs) {
            rep.add(this.explicitInitialAbstraction.getRepresentative(ai));
        }
        return rep;
    }

    public Map<AI, ExplicitAbstractionTree<AI, CI, D>> getAbstractionTrees() {
        return this.trees;
    }
}

