/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.kv.dfa;

import de.learnlib.Resumable;
import de.learnlib.acex.AbstractBaseCounterexample;
import de.learnlib.acex.AcexAnalyzer;
import de.learnlib.acex.AcexAnalyzers;
import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.kv.StateInfo;
import de.learnlib.algorithm.kv.dfa.KearnsVaziraniDFAState;
import de.learnlib.datastructure.discriminationtree.BinaryDTree;
import de.learnlib.datastructure.discriminationtree.model.AbstractDTNode;
import de.learnlib.datastructure.discriminationtree.model.AbstractWordBasedDTNode;
import de.learnlib.datastructure.discriminationtree.model.LCAInfo;
import de.learnlib.logging.Category;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.fsa.CompactDFA;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.common.smartcollection.ArrayStorage;
import net.automatalib.word.Word;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KearnsVaziraniDFA<I>
implements LearningAlgorithm.DFALearner<I>,
SupportsGrowingAlphabet<I>,
Resumable<KearnsVaziraniDFAState<I>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KearnsVaziraniDFA.class);
    private final Alphabet<I> alphabet;
    private final MembershipOracle<I, Boolean> oracle;
    private final boolean repeatedCounterexampleEvaluation;
    private final AcexAnalyzer ceAnalyzer;
    private BinaryDTree<I, StateInfo<I, Boolean>> discriminationTree;
    protected List<StateInfo<I, Boolean>> stateInfos = new ArrayList<StateInfo<I, Boolean>>();
    private CompactDFA<I> hypothesis;

    public KearnsVaziraniDFA(Alphabet<I> alphabet, MembershipOracle<I, Boolean> oracle, boolean repeatedCounterexampleEvaluation, AcexAnalyzer counterexampleAnalyzer) {
        this.alphabet = alphabet;
        this.hypothesis = new CompactDFA<I>(alphabet);
        this.discriminationTree = new BinaryDTree(oracle);
        this.oracle = oracle;
        this.repeatedCounterexampleEvaluation = repeatedCounterexampleEvaluation;
        this.ceAnalyzer = counterexampleAnalyzer;
    }

    @Override
    public void startLearning() {
        this.initialize();
    }

    @Override
    public boolean refineHypothesis(DefaultQuery<I, Boolean> ceQuery) {
        boolean output;
        if (this.hypothesis.size() == 0) {
            throw new IllegalStateException("Not initialized");
        }
        Word input = ceQuery.getInput();
        if (!this.refineHypothesisSingle(input, output = ceQuery.getOutput().booleanValue())) {
            return false;
        }
        if (this.repeatedCounterexampleEvaluation) {
            while (this.refineHypothesisSingle(input, output)) {
            }
        }
        return true;
    }

    @Override
    public DFA<?, I> getHypothesisModel() {
        if (this.hypothesis.size() == 0) {
            throw new IllegalStateException("Not started");
        }
        return this.hypothesis;
    }

    public BinaryDTree<I, StateInfo<I, Boolean>> getDiscriminationTree() {
        return this.discriminationTree;
    }

    private boolean refineHypothesisSingle(Word<I> input, boolean output) {
        int inputLen = input.length();
        if (inputLen < 2) {
            return false;
        }
        if (this.hypothesis.accepts(input) == output) {
            return false;
        }
        KVAbstractCounterexample acex = new KVAbstractCounterexample(input, output, this.oracle);
        int idx = this.ceAnalyzer.analyzeAbstractCounterexample(acex, 1);
        Word<I> prefix = input.prefix(idx);
        StateInfo srcStateInfo = acex.getStateInfo(idx);
        I sym = input.getSymbol(idx);
        LCAInfo lca = acex.getLCA(idx + 1);
        assert (lca != null);
        this.splitState(srcStateInfo, prefix, sym, lca);
        return true;
    }

    private void splitState(StateInfo<I, Boolean> stateInfo, Word<I> newPrefix, I sym, LCAInfo<Boolean, AbstractWordBasedDTNode<I, Boolean, StateInfo<I, Boolean>>> separatorInfo) {
        int state = stateInfo.id;
        boolean oldAccepting = this.hypothesis.isAccepting(state);
        List<Long> oldIncoming = stateInfo.fetchIncoming();
        StateInfo<I, Boolean> newStateInfo = this.createState(newPrefix, oldAccepting);
        AbstractWordBasedDTNode stateLeaf = stateInfo.dtNode;
        AbstractWordBasedDTNode separator = (AbstractWordBasedDTNode)separatorInfo.leastCommonAncestor;
        Word<I> newDiscriminator = this.newDiscriminator(sym, (Word)separator.getDiscriminator());
        AbstractDTNode.SplitResult sr = stateLeaf.split(newDiscriminator, (StateInfo<I, Boolean>)((Object)((Boolean)separatorInfo.subtree1Label)), (StateInfo<I, Boolean>)((Object)((Boolean)separatorInfo.subtree2Label)), newStateInfo);
        stateInfo.dtNode = (AbstractWordBasedDTNode)sr.nodeOld;
        newStateInfo.dtNode = (AbstractWordBasedDTNode)sr.nodeNew;
        this.initState(newStateInfo);
        this.updateTransitions(oldIncoming, stateLeaf);
    }

    private void updateTransitions(List<Long> transList, AbstractWordBasedDTNode<I, Boolean, StateInfo<I, Boolean>> oldDtTarget) {
        int numTrans = transList.size();
        ArrayList<Word<I>> transAs = new ArrayList<Word<I>>(numTrans);
        for (int i = 0; i < numTrans; ++i) {
            long encodedTrans = transList.get(i);
            int sourceState = (int)(encodedTrans >> 32);
            int transIdx = (int)encodedTrans;
            StateInfo<I, Boolean> sourceInfo = this.stateInfos.get(sourceState);
            I symbol = this.alphabet.getSymbol(transIdx);
            transAs.add(sourceInfo.accessSequence.append(symbol));
        }
        List<StateInfo<I, Boolean>> succs = this.sift(Collections.nCopies(numTrans, oldDtTarget), transAs);
        for (int i = 0; i < numTrans; ++i) {
            long encodedTrans = transList.get(i);
            int sourceState = (int)(encodedTrans >> 32);
            int transIdx = (int)encodedTrans;
            this.setTransition(sourceState, transIdx, succs.get(i));
        }
    }

    private Word<I> newDiscriminator(I symbol, Word<I> succDiscriminator) {
        return succDiscriminator.prepend(symbol);
    }

    private void initialize() {
        boolean initAccepting = this.oracle.answerQuery(Word.epsilon());
        StateInfo<I, Boolean> initStateInfo = this.createInitialState(initAccepting);
        AbstractWordBasedDTNode root = (AbstractWordBasedDTNode)this.discriminationTree.getRoot();
        root.setData(initStateInfo);
        initStateInfo.dtNode = (AbstractWordBasedDTNode)root.split(Word.epsilon(), Boolean.valueOf((boolean)initAccepting), Boolean.valueOf((boolean)(!initAccepting ? true : false))).nodeOld;
        this.initState(initStateInfo);
    }

    private StateInfo<I, Boolean> createInitialState(boolean accepting) {
        int state = this.hypothesis.addIntInitialState(accepting);
        StateInfo si = new StateInfo(state, Word.epsilon());
        assert (this.stateInfos.size() == state);
        this.stateInfos.add(si);
        return si;
    }

    private StateInfo<I, Boolean> createState(Word<I> accessSequence, boolean accepting) {
        int state = this.hypothesis.addIntState(accepting);
        StateInfo si = new StateInfo(state, accessSequence);
        assert (this.stateInfos.size() == state);
        this.stateInfos.add(si);
        return si;
    }

    private void initState(StateInfo<I, Boolean> stateInfo) {
        int alphabetSize = this.alphabet.size();
        int state = stateInfo.id;
        Word<I> accessSequence = stateInfo.accessSequence;
        ArrayStorage<Word<I>> transAs = new ArrayStorage<Word<I>>(alphabetSize);
        for (int i = 0; i < alphabetSize; ++i) {
            I sym = this.alphabet.getSymbol(i);
            transAs.set(i, accessSequence.append(sym));
        }
        List<StateInfo<I, Boolean>> succs = this.sift(transAs);
        for (int i = 0; i < alphabetSize; ++i) {
            this.setTransition(state, i, succs.get(i));
        }
    }

    private void setTransition(int state, int symIdx, StateInfo<I, Boolean> succInfo) {
        succInfo.addIncoming(state, symIdx);
        this.hypothesis.setTransition(state, symIdx, succInfo.id);
    }

    private List<StateInfo<I, Boolean>> sift(List<Word<I>> prefixes) {
        return this.sift(Collections.nCopies(prefixes.size(), (AbstractWordBasedDTNode)this.discriminationTree.getRoot()), prefixes);
    }

    private List<StateInfo<I, Boolean>> sift(List<AbstractWordBasedDTNode<I, Boolean, StateInfo<I, Boolean>>> starts, List<Word<I>> prefixes) {
        List<AbstractWordBasedDTNode<I, Boolean, StateInfo<I, Boolean>>> leaves = this.discriminationTree.sift(starts, prefixes);
        ArrayStorage<StateInfo<I, Boolean>> result = new ArrayStorage<StateInfo<I, Boolean>>(leaves.size());
        for (int i = 0; i < leaves.size(); ++i) {
            AbstractWordBasedDTNode<I, Boolean, StateInfo<I, Boolean>> leaf = leaves.get(i);
            StateInfo<I, Boolean> succStateInfo = (StateInfo<I, Boolean>)leaf.getData();
            if (succStateInfo == null) {
                boolean initAccepting;
                succStateInfo = this.createState(prefixes.get(i), !(initAccepting = this.hypothesis.isAccepting(this.hypothesis.getIntInitialState())));
                leaf.setData(succStateInfo);
                succStateInfo.dtNode = leaf;
                this.initState(succStateInfo);
            }
            result.set(i, succStateInfo);
        }
        return result;
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        if (!this.alphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.alphabet).addSymbol(symbol);
        }
        this.hypothesis.addAlphabetSymbol(symbol);
        if (this.hypothesis.getInitialState() != null && this.hypothesis.getSuccessor(this.hypothesis.getInitialState(), symbol) == null) {
            ArrayList<Word<I>> transAs = new ArrayList<Word<I>>(this.stateInfos.size());
            for (StateInfo<I, Boolean> si : this.stateInfos) {
                transAs.add(si.accessSequence.append(symbol));
            }
            List<StateInfo<I, Boolean>> succs = this.sift(transAs);
            Iterator stateIter = this.stateInfos.iterator();
            Iterator<StateInfo<I, Boolean>> leafsIter = succs.iterator();
            int inputIdx = this.alphabet.getSymbolIndex(symbol);
            while (stateIter.hasNext() && leafsIter.hasNext()) {
                this.setTransition(stateIter.next().id, inputIdx, leafsIter.next());
            }
            assert (!stateIter.hasNext() || !((BooleanSupplier)() -> {
                stateIter.next();
                return stateIter.hasNext();
            }).getAsBoolean());
            assert (!leafsIter.hasNext());
        }
    }

    @Override
    public KearnsVaziraniDFAState<I> suspend() {
        return new KearnsVaziraniDFAState<I>(this.hypothesis, this.discriminationTree, this.stateInfos);
    }

    @Override
    public void resume(KearnsVaziraniDFAState<I> state) {
        this.hypothesis = state.getHypothesis();
        this.discriminationTree = state.getDiscriminationTree();
        this.discriminationTree.setOracle(this.oracle);
        this.stateInfos = state.getStateInfos();
        Alphabet oldAlphabet = this.hypothesis.getInputAlphabet();
        if (!oldAlphabet.equals(this.alphabet)) {
            LOGGER.warn(Category.DATASTRUCTURE, "The current alphabet '{}' differs from the resumed alphabet '{}'. Future behavior may be inconsistent", (Object)this.alphabet, (Object)oldAlphabet);
        }
    }

    protected class KVAbstractCounterexample
    extends AbstractBaseCounterexample<Boolean> {
        private final Word<I> ceWord;
        private final MembershipOracle<I, Boolean> oracle;
        private final StateInfo<I, Boolean>[] states;
        private final LCAInfo<Boolean, AbstractWordBasedDTNode<I, Boolean, StateInfo<I, Boolean>>>[] lcas;

        public KVAbstractCounterexample(Word<I> ceWord, boolean output, MembershipOracle<I, Boolean> oracle) {
            super(ceWord.length() + 1);
            this.ceWord = ceWord;
            this.oracle = oracle;
            int m3 = ceWord.length();
            this.states = new StateInfo[m3 + 1];
            this.lcas = new LCAInfo[m3 + 1];
            int i = 0;
            int currState = KearnsVaziraniDFA.this.hypothesis.getIntInitialState();
            this.states[i++] = KearnsVaziraniDFA.this.stateInfos.get(currState);
            for (Object sym : ceWord) {
                currState = KearnsVaziraniDFA.this.hypothesis.getSuccessor(currState, sym);
                this.states[i++] = KearnsVaziraniDFA.this.stateInfos.get(currState);
            }
            this.lcas[m3] = new LCAInfo<Boolean, AbstractWordBasedDTNode>((AbstractWordBasedDTNode)KearnsVaziraniDFA.this.discriminationTree.getRoot(), !output, output);
        }

        public StateInfo<I, Boolean> getStateInfo(int idx) {
            return this.states[idx];
        }

        public LCAInfo<Boolean, AbstractWordBasedDTNode<I, Boolean, StateInfo<I, Boolean>>> getLCA(int idx) {
            return this.lcas[idx];
        }

        @Override
        protected Boolean computeEffect(int index) {
            Word prefix = this.ceWord.prefix(index);
            StateInfo info = this.states[index];
            AbstractWordBasedDTNode node = info.dtNode;
            ArrayDeque<Boolean> expect = new ArrayDeque<Boolean>();
            while (!node.isRoot()) {
                Boolean parentOutcome = (Boolean)node.getParentOutcome();
                assert (parentOutcome != null);
                expect.push(parentOutcome);
                node = (AbstractWordBasedDTNode)node.getParent();
            }
            AbstractWordBasedDTNode currNode = (AbstractWordBasedDTNode)KearnsVaziraniDFA.this.discriminationTree.getRoot();
            while (!expect.isEmpty()) {
                Word suffix = (Word)currNode.getDiscriminator();
                boolean out = this.oracle.answerQuery(prefix, suffix);
                if (out != (Boolean)expect.pop()) {
                    this.lcas[index] = new LCAInfo<Boolean, AbstractWordBasedDTNode>(currNode, !out, out);
                    return false;
                }
                currNode = (AbstractWordBasedDTNode)currNode.child(out);
            }
            assert (currNode.isLeaf() && expect.isEmpty());
            return true;
        }

        @Override
        public boolean checkEffects(Boolean eff1, Boolean eff2) {
            return eff1 == false || eff2 != false;
        }
    }

    static final class BuilderDefaults {
        private BuilderDefaults() {
        }

        public static boolean repeatedCounterexampleEvaluation() {
            return true;
        }

        public static AcexAnalyzer counterexampleAnalyzer() {
            return AcexAnalyzers.LINEAR_FWD;
        }
    }
}

