/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.kv.mealy;

import de.learnlib.Resumable;
import de.learnlib.acex.AbstractBaseCounterexample;
import de.learnlib.acex.AcexAnalyzer;
import de.learnlib.acex.AcexAnalyzers;
import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.kv.StateInfo;
import de.learnlib.algorithm.kv.mealy.KearnsVaziraniMealyState;
import de.learnlib.datastructure.discriminationtree.MultiDTree;
import de.learnlib.datastructure.discriminationtree.model.AbstractDTNode;
import de.learnlib.datastructure.discriminationtree.model.AbstractWordBasedDTNode;
import de.learnlib.datastructure.discriminationtree.model.LCAInfo;
import de.learnlib.logging.Category;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.util.mealy.MealyUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.CompactTransition;
import net.automatalib.automaton.transducer.CompactMealy;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KearnsVaziraniMealy<I, O>
implements LearningAlgorithm.MealyLearner<I, O>,
SupportsGrowingAlphabet<I>,
Resumable<KearnsVaziraniMealyState<I, O>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KearnsVaziraniMealy.class);
    private final Alphabet<I> alphabet;
    private final MembershipOracle<I, Word<O>> oracle;
    private final boolean repeatedCounterexampleEvaluation;
    private final AcexAnalyzer ceAnalyzer;
    private MultiDTree<I, Word<O>, StateInfo<I, Word<O>>> discriminationTree;
    protected List<StateInfo<I, Word<O>>> stateInfos = new ArrayList<StateInfo<I, Word<O>>>();
    private CompactMealy<I, O> hypothesis;

    public KearnsVaziraniMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle, boolean repeatedCounterexampleEvaluation, AcexAnalyzer counterexampleAnalyzer) {
        this.alphabet = alphabet;
        this.hypothesis = new CompactMealy(alphabet);
        this.oracle = oracle;
        this.repeatedCounterexampleEvaluation = repeatedCounterexampleEvaluation;
        this.discriminationTree = new MultiDTree(oracle);
        this.ceAnalyzer = counterexampleAnalyzer;
    }

    @Override
    public void startLearning() {
        this.initialize();
    }

    @Override
    public boolean refineHypothesis(DefaultQuery<I, Word<O>> ceQuery) {
        Word<O> output;
        if (this.hypothesis.size() == 0) {
            throw new IllegalStateException("Not initialized");
        }
        Word input = ceQuery.getInput();
        if (!this.refineHypothesisSingle(input, output = ceQuery.getOutput())) {
            return false;
        }
        if (this.repeatedCounterexampleEvaluation) {
            while (this.refineHypothesisSingle(input, output)) {
            }
        }
        return true;
    }

    @Override
    public MealyMachine<?, I, ?, O> getHypothesisModel() {
        if (this.hypothesis.size() == 0) {
            throw new IllegalStateException("Not started");
        }
        return this.hypothesis;
    }

    public MultiDTree<I, Word<O>, StateInfo<I, Word<O>>> getDiscriminationTree() {
        return this.discriminationTree;
    }

    private boolean refineHypothesisSingle(Word<I> input, Word<O> output) {
        int inputLen = input.length();
        if (inputLen < 2) {
            return false;
        }
        int mismatchIdx = MealyUtil.findMismatch(this.hypothesis, input, output);
        if (mismatchIdx == -1) {
            return false;
        }
        Word<I> effInput = input.prefix(mismatchIdx + 1);
        Word<O> effOutput = output.prefix(mismatchIdx + 1);
        KVAbstractCounterexample acex = new KVAbstractCounterexample(effInput, effOutput, this.oracle);
        int idx = this.ceAnalyzer.analyzeAbstractCounterexample(acex, 0);
        Word<I> prefix = effInput.prefix(idx);
        StateInfo srcStateInfo = acex.getStateInfo(idx);
        I sym = effInput.getSymbol(idx);
        LCAInfo<Word<O>, @Nullable AbstractWordBasedDTNode<I, Word<O>, StateInfo<I, Word<O>>>> lca = acex.getLCA(idx + 1);
        assert (lca != null);
        this.splitState(srcStateInfo, prefix, sym, lca);
        return true;
    }

    private void splitState(StateInfo<I, Word<O>> stateInfo, Word<I> newPrefix, I sym, LCAInfo<Word<O>, @Nullable AbstractWordBasedDTNode<I, Word<O>, StateInfo<I, Word<O>>>> separatorInfo) {
        Word<O> newOut;
        Word<O> oldOut;
        Word<I> newDiscriminator;
        int state = stateInfo.id;
        List<Long> oldIncoming = stateInfo.fetchIncoming();
        StateInfo<I, Word<O>> newStateInfo = this.createState(newPrefix);
        AbstractWordBasedDTNode stateLeaf = stateInfo.dtNode;
        AbstractWordBasedDTNode separator = (AbstractWordBasedDTNode)separatorInfo.leastCommonAncestor;
        if (separator == null) {
            newDiscriminator = Word.fromLetter(sym);
            oldOut = (Word<O>)separatorInfo.subtree1Label;
            newOut = (Word<O>)separatorInfo.subtree2Label;
        } else {
            newDiscriminator = this.newDiscriminator(sym, (Word)separator.getDiscriminator());
            CompactTransition transition = (CompactTransition)this.hypothesis.getTransition(state, sym);
            assert (transition != null);
            O transOut = this.hypothesis.getTransitionOutput(transition);
            oldOut = this.newOutcome(transOut, (Word)separatorInfo.subtree1Label);
            newOut = this.newOutcome(transOut, (Word)separatorInfo.subtree2Label);
        }
        AbstractDTNode.SplitResult sr = stateLeaf.split(newDiscriminator, (StateInfo<I, Word<O>>)((Object)oldOut), (StateInfo<I, Word<O>>)((Object)newOut), newStateInfo);
        stateInfo.dtNode = (AbstractWordBasedDTNode)sr.nodeOld;
        newStateInfo.dtNode = (AbstractWordBasedDTNode)sr.nodeNew;
        this.initState(newStateInfo);
        this.updateTransitions(oldIncoming, stateLeaf);
    }

    private Word<O> newOutcome(O transOutput, Word<O> succOutcome) {
        return succOutcome.prepend(transOutput);
    }

    private void updateTransitions(List<Long> transList, AbstractWordBasedDTNode<I, Word<O>, StateInfo<I, Word<O>>> oldDtTarget) {
        int numTrans = transList.size();
        ArrayList<Word<I>> transAs = new ArrayList<Word<I>>(numTrans);
        for (int i = 0; i < numTrans; ++i) {
            long encodedTrans = transList.get(i);
            int sourceState = (int)(encodedTrans >> 32);
            int transIdx = (int)encodedTrans;
            StateInfo<I, Word<O>> sourceInfo = this.stateInfos.get(sourceState);
            I symbol = this.alphabet.getSymbol(transIdx);
            transAs.add(sourceInfo.accessSequence.append(symbol));
        }
        List<StateInfo<I, Word<O>>> succs = this.sift(Collections.nCopies(numTrans, oldDtTarget), transAs);
        for (int i = 0; i < numTrans; ++i) {
            long encodedTrans = transList.get(i);
            int sourceState = (int)(encodedTrans >> 32);
            int transIdx = (int)encodedTrans;
            Object trans = this.hypothesis.getTransition(sourceState, transIdx);
            assert (trans != null);
            this.setTransition(sourceState, transIdx, succs.get(i), ((CompactTransition)trans).getProperty());
        }
    }

    private Word<I> newDiscriminator(I symbol, Word<I> succDiscriminator) {
        return succDiscriminator.prepend(symbol);
    }

    private StateInfo<I, Word<O>> createInitialState() {
        int state = this.hypothesis.addIntInitialState();
        assert (state == this.stateInfos.size());
        StateInfo stateInfo = new StateInfo(state, Word.epsilon());
        this.stateInfos.add(stateInfo);
        return stateInfo;
    }

    private StateInfo<I, Word<O>> createState(Word<I> prefix) {
        int state = this.hypothesis.addIntState();
        assert (state == this.stateInfos.size());
        StateInfo stateInfo = new StateInfo(state, prefix);
        this.stateInfos.add(stateInfo);
        return stateInfo;
    }

    private void initialize() {
        StateInfo<I, Word<O>> init = this.createInitialState();
        ((AbstractWordBasedDTNode)this.discriminationTree.getRoot()).setData(init);
        init.dtNode = (AbstractWordBasedDTNode)this.discriminationTree.getRoot();
        this.initState(init);
    }

    private void initState(StateInfo<I, Word<O>> stateInfo) {
        int alphabetSize = this.alphabet.size();
        int state = stateInfo.id;
        Word<I> accessSequence = stateInfo.accessSequence;
        ArrayList<Word<I>> transAs = new ArrayList<Word<I>>(alphabetSize);
        ArrayList outputQueries = new ArrayList(alphabetSize);
        for (int i = 0; i < alphabetSize; ++i) {
            I sym = this.alphabet.getSymbol(i);
            transAs.add(accessSequence.append(sym));
            outputQueries.add(new DefaultQuery(accessSequence, Word.fromLetter(sym)));
        }
        List<StateInfo<I, Word<O>>> succs = this.sift(transAs);
        this.oracle.processQueries(outputQueries);
        for (int i = 0; i < alphabetSize; ++i) {
            this.setTransition(state, i, succs.get(i), ((Word)((DefaultQuery)outputQueries.get(i)).getOutput()).firstSymbol());
        }
    }

    private void setTransition(int state, int symIdx, StateInfo<I, Word<O>> succInfo, O output) {
        succInfo.addIncoming(state, symIdx);
        this.hypothesis.setTransition(state, symIdx, succInfo.id, output);
    }

    private List<StateInfo<I, Word<O>>> sift(List<Word<I>> prefixes) {
        return this.sift(Collections.nCopies(prefixes.size(), (AbstractWordBasedDTNode)this.discriminationTree.getRoot()), prefixes);
    }

    private List<StateInfo<I, Word<O>>> sift(List<AbstractWordBasedDTNode<I, Word<O>, StateInfo<I, Word<O>>>> starts, List<Word<I>> prefixes) {
        List<AbstractWordBasedDTNode<I, Word<O>, StateInfo<I, Word<O>>>> leaves = this.discriminationTree.sift(starts, prefixes);
        ArrayList<StateInfo<I, Word<O>>> result = new ArrayList<StateInfo<I, Word<O>>>(leaves.size());
        for (int i = 0; i < leaves.size(); ++i) {
            AbstractWordBasedDTNode<I, Word<O>, StateInfo<I, Word<O>>> leaf = leaves.get(i);
            StateInfo<I, Word<O>> succStateInfo = (StateInfo<I, Word<O>>)leaf.getData();
            if (succStateInfo == null) {
                succStateInfo = this.createState(prefixes.get(i));
                leaf.setData(succStateInfo);
                succStateInfo.dtNode = leaf;
                this.initState(succStateInfo);
            }
            result.add(succStateInfo);
        }
        return result;
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        if (!this.alphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.alphabet).addSymbol(symbol);
        }
        this.hypothesis.addAlphabetSymbol(symbol);
        if (this.hypothesis.getInitialState() != null && this.hypothesis.getSuccessor(this.hypothesis.getInitialState(), symbol) == null) {
            ArrayList<Word<I>> transAs = new ArrayList<Word<I>>(this.stateInfos.size());
            ArrayList outputQueries = new ArrayList(this.stateInfos.size());
            for (StateInfo<I, Word<O>> si : this.stateInfos) {
                transAs.add(si.accessSequence.append(symbol));
                outputQueries.add(new DefaultQuery(si.accessSequence, Word.fromLetter(symbol)));
            }
            List<StateInfo<I, Word<O>>> succs = this.sift(transAs);
            this.oracle.processQueries(outputQueries);
            Iterator<StateInfo<I, Word<O>>> stateIter = this.stateInfos.iterator();
            Iterator<StateInfo<I, Word<O>>> leafsIter = succs.iterator();
            Iterator outputsIter = outputQueries.iterator();
            int inputIdx = this.alphabet.getSymbolIndex(symbol);
            while (stateIter.hasNext() && leafsIter.hasNext()) {
                this.setTransition(stateIter.next().id, inputIdx, leafsIter.next(), ((Word)((DefaultQuery)outputsIter.next()).getOutput()).firstSymbol());
            }
        }
    }

    @Override
    public KearnsVaziraniMealyState<I, O> suspend() {
        return new KearnsVaziraniMealyState<I, O>(this.hypothesis, this.discriminationTree, this.stateInfos);
    }

    @Override
    public void resume(KearnsVaziraniMealyState<I, O> state) {
        this.hypothesis = state.getHypothesis();
        this.discriminationTree = state.getDiscriminationTree();
        this.discriminationTree.setOracle(this.oracle);
        this.stateInfos = state.getStateInfos();
        Alphabet oldAlphabet = this.hypothesis.getInputAlphabet();
        if (!oldAlphabet.equals(this.alphabet)) {
            LOGGER.warn(Category.DATASTRUCTURE, "The current alphabet '{}' differs from the resumed alphabet '{}'. Future behavior may be inconsistent", (Object)this.alphabet, (Object)oldAlphabet);
        }
    }

    protected class KVAbstractCounterexample
    extends AbstractBaseCounterexample<Boolean> {
        private final Word<I> ceWord;
        private final MembershipOracle<I, Word<O>> oracle;
        private final StateInfo<I, Word<O>>[] states;
        private final LCAInfo<Word<O>, @Nullable AbstractWordBasedDTNode<I, Word<O>, StateInfo<I, Word<O>>>>[] lcas;

        public KVAbstractCounterexample(Word<I> ceWord, Word<O> output, MembershipOracle<I, Word<O>> oracle) {
            super(ceWord.length() + 1);
            this.ceWord = ceWord;
            this.oracle = oracle;
            int m3 = ceWord.length();
            this.states = new StateInfo[m3 + 1];
            this.lcas = new LCAInfo[m3 + 1];
            int currState = KearnsVaziraniMealy.this.hypothesis.getIntInitialState();
            int i = 0;
            this.states[i++] = KearnsVaziraniMealy.this.stateInfos.get(currState);
            for (Object sym : ceWord) {
                currState = KearnsVaziraniMealy.this.hypothesis.getSuccessor(currState, sym);
                this.states[i++] = KearnsVaziraniMealy.this.stateInfos.get(currState);
            }
            Object lastHypOut = KearnsVaziraniMealy.this.hypothesis.getOutput(this.states[m3 - 1].id, ceWord.lastSymbol());
            this.lcas[m3] = new LCAInfo(null, Word.fromLetter(lastHypOut), Word.fromLetter(output.lastSymbol()));
            super.setEffect(m3, false);
        }

        public StateInfo<I, Word<O>> getStateInfo(int idx) {
            return this.states[idx];
        }

        public LCAInfo<Word<O>, @Nullable AbstractWordBasedDTNode<I, Word<O>, StateInfo<I, Word<O>>>> getLCA(int idx) {
            return this.lcas[idx];
        }

        @Override
        protected Boolean computeEffect(int index) {
            Word prefix = this.ceWord.prefix(index);
            StateInfo info = this.states[index];
            AbstractWordBasedDTNode node = info.dtNode;
            ArrayDeque<Word> expect = new ArrayDeque<Word>();
            while (!node.isRoot()) {
                Word parentOutcome = (Word)node.getParentOutcome();
                assert (parentOutcome != null);
                expect.push(parentOutcome);
                node = (AbstractWordBasedDTNode)node.getParent();
            }
            AbstractWordBasedDTNode currNode = (AbstractWordBasedDTNode)KearnsVaziraniMealy.this.discriminationTree.getRoot();
            while (!expect.isEmpty()) {
                Word e;
                Word suffix = (Word)currNode.getDiscriminator();
                Word out = this.oracle.answerQuery(prefix, suffix);
                if (!Objects.equals(out, e = (Word)expect.pop())) {
                    this.lcas[index] = new LCAInfo(currNode, e, out);
                    return false;
                }
                currNode = (AbstractWordBasedDTNode)currNode.child(out);
            }
            assert (currNode.isLeaf() && expect.isEmpty());
            return true;
        }

        @Override
        public boolean checkEffects(Boolean eff1, Boolean eff2) {
            return eff1 == false || eff2 != false;
        }
    }

    static final class BuilderDefaults {
        private BuilderDefaults() {
        }

        public static boolean repeatedCounterexampleEvaluation() {
            return true;
        }

        public static AcexAnalyzer counterexampleAnalyzer() {
            return AcexAnalyzers.LINEAR_FWD;
        }
    }
}

