/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.lstar.mealy;

import de.learnlib.algorithm.GlobalSuffixLearner;
import de.learnlib.algorithm.lstar.AbstractExtensibleAutomatonLStar;
import de.learnlib.algorithm.lstar.ce.ObservationTableCEXHandler;
import de.learnlib.algorithm.lstar.closing.ClosingStrategy;
import de.learnlib.algorithm.lstar.mealy.LStarMealyUtil;
import de.learnlib.datastructure.observationtable.OTLearner;
import de.learnlib.datastructure.observationtable.ObservationTable;
import de.learnlib.datastructure.observationtable.Row;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.CompactTransition;
import net.automatalib.automaton.concept.SuffixOutput;
import net.automatalib.automaton.transducer.CompactMealy;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.word.Word;

public class ExtensibleLStarMealy<I, O>
extends AbstractExtensibleAutomatonLStar<MealyMachine<?, I, ?, O>, I, Word<O>, Integer, CompactTransition<O>, Void, O, CompactMealy<I, O>>
implements OTLearner.OTLearnerMealy<I, O>,
GlobalSuffixLearner.GlobalSuffixLearnerMealy<I, O> {
    private final List<O> outputTable = new ArrayList<O>();

    public ExtensibleLStarMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle, List<Word<I>> initialSuffixes, ObservationTableCEXHandler<? super I, ? super Word<O>> cexHandler, ClosingStrategy<? super I, ? super Word<O>> closingStrategy) {
        this(alphabet, oracle, Collections.singletonList(Word.epsilon()), initialSuffixes, cexHandler, closingStrategy);
    }

    public ExtensibleLStarMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle, List<Word<I>> initialPrefixes, List<Word<I>> initialSuffixes, ObservationTableCEXHandler<? super I, ? super Word<O>> cexHandler, ClosingStrategy<? super I, ? super Word<O>> closingStrategy) {
        super(alphabet, oracle, new CompactMealy(alphabet), initialPrefixes, LStarMealyUtil.ensureSuffixCompliancy(initialSuffixes, alphabet, cexHandler.needsConsistencyCheck()), cexHandler, closingStrategy);
    }

    @Override
    public MealyMachine<?, I, ?, O> getHypothesisModel() {
        return (MealyMachine)((Object)this.internalHyp);
    }

    @Override
    protected void updateInternalHypothesis() {
        this.updateOutputs();
        super.updateInternalHypothesis();
    }

    @Override
    protected Void stateProperty(ObservationTable<I, Word<O>> table, Row<I> stateRow) {
        return null;
    }

    @Override
    protected O transitionProperty(ObservationTable<I, Word<O>> table, Row<I> stateRow, int inputIdx) {
        Row<I> transRow = stateRow.getSuccessor(inputIdx);
        return this.outputTable.get(transRow.getRowId() - 1);
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        if (this.cexHandler.needsConsistencyCheck()) {
            Word<I> suffix = Word.fromLetter(symbol);
            if (this.table.isInitialized()) {
                super.addGlobalSuffixes(Collections.singleton(suffix));
            } else {
                this.initialSuffixes.add(suffix);
            }
        }
        super.addAlphabetSymbol(symbol);
    }

    protected void updateOutputs() {
        int i;
        int numOutputs = this.outputTable.size();
        int numTransRows = this.table.numberOfRows() - 1;
        int newOutputs = numTransRows - numOutputs;
        if (newOutputs == 0) {
            return;
        }
        ArrayList outputQueries = new ArrayList(numOutputs);
        for (i = numOutputs + 1; i <= numTransRows; ++i) {
            Row row = this.table.getRow(i);
            Word rowPrefix = row.getLabel();
            int prefixLen = rowPrefix.size();
            outputQueries.add(new DefaultQuery(rowPrefix.prefix(prefixLen - 1), rowPrefix.suffix(1)));
        }
        this.oracle.processQueries(outputQueries);
        for (i = 0; i < newOutputs; ++i) {
            DefaultQuery query = (DefaultQuery)outputQueries.get(i);
            Object outSym = ((Word)query.getOutput()).getSymbol(0);
            this.outputTable.add(outSym);
        }
    }

    @Override
    protected SuffixOutput<I, Word<O>> hypothesisOutput() {
        return (SuffixOutput)((Object)this.internalHyp);
    }
}

