/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.observationpack.hypothesis;

import de.learnlib.AccessSequenceTransformer;
import de.learnlib.algorithm.observationpack.hypothesis.HState;
import de.learnlib.algorithm.observationpack.hypothesis.HTransition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.automaton.concept.StateIDs;
import net.automatalib.graph.Graph;
import net.automatalib.graph.concept.GraphViewable;
import net.automatalib.graph.concept.NodeIDs;
import net.automatalib.visualization.DefaultVisualizationHelper;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.word.Word;

public class OPLearnerHypothesis<I, O, SP, TP>
implements UniversalDeterministicAutomaton<HState<I, O, SP, TP>, I, HTransition<I, O, SP, TP>, SP, TP>,
AccessSequenceTransformer<I>,
StateIDs<HState<I, O, SP, TP>>,
SupportsGrowingAlphabet<I>,
GraphViewable {
    private final Alphabet<I> alphabet;
    private int alphabetSize;
    private HState<I, O, SP, TP> root;
    private final List<HState<I, O, SP, TP>> nodes = new ArrayList<HState<I, O, SP, TP>>();

    public OPLearnerHypothesis(Alphabet<I> alphabet) {
        this.alphabet = alphabet;
        this.alphabetSize = this.alphabet.size();
    }

    public HState<I, O, SP, TP> createInitialState() {
        this.root = new HState(this.alphabetSize);
        this.nodes.add(this.root);
        return this.root;
    }

    public HState<I, O, SP, TP> createState(HTransition<I, O, SP, TP> treeIncoming) {
        HState<I, O, SP, TP> state = new HState<I, O, SP, TP>(this.alphabetSize, this.nodes.size(), treeIncoming);
        this.nodes.add(state);
        treeIncoming.makeTree(state);
        return state;
    }

    @Override
    public HTransition<I, O, SP, TP> getTransition(HState<I, O, SP, TP> state, I symbol) {
        int symIdx = this.alphabet.getSymbolIndex(symbol);
        return state.getTransition(symIdx);
    }

    @Override
    public HState<I, O, SP, TP> getInitialState() {
        return this.root;
    }

    @Override
    public SP getStateProperty(HState<I, O, SP, TP> state) {
        return state.getProperty();
    }

    @Override
    public TP getTransitionProperty(HTransition<I, O, SP, TP> trans) {
        return trans.getProperty();
    }

    @Override
    public int getStateId(HState<I, O, SP, TP> state) {
        return state.getId();
    }

    @Override
    public HState<I, O, SP, TP> getState(int id) {
        if (id < 0 || id >= this.nodes.size()) {
            throw new IndexOutOfBoundsException("No valid id");
        }
        return this.nodes.get(id);
    }

    @Override
    public Word<I> transformAccessSequence(Word<I> word) {
        HState state = (HState)this.getState(word);
        assert (state != null);
        return state.getAccessSequence();
    }

    @Override
    public boolean isAccessSequence(Word<I> word) {
        HState<I, O, SP, TP> curr = this.root;
        for (I sym : word) {
            int symIdx = this.alphabet.getSymbolIndex(sym);
            HTransition<I, O, SP, TP> trans = curr.getTransition(symIdx);
            if (!trans.isTree()) {
                return false;
            }
            curr = trans.getTreeTarget();
        }
        return true;
    }

    @Override
    public HState<I, O, SP, TP> getSuccessor(HTransition<I, O, SP, TP> trans) {
        return trans.currentTarget();
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        int newAlphabetSize;
        if (!this.alphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.alphabet).addSymbol(symbol);
        }
        if (this.alphabetSize < (newAlphabetSize = this.alphabet.size())) {
            for (HState<I, O, SP, TP> s2 : this.getStates()) {
                s2.ensureInputCapacity(newAlphabetSize);
            }
            this.alphabetSize = newAlphabetSize;
        }
    }

    @Override
    public Collection<HState<I, O, SP, TP>> getStates() {
        return Collections.unmodifiableCollection(this.nodes);
    }

    @Override
    public StateIDs<HState<I, O, SP, TP>> stateIDs() {
        return this;
    }

    public GraphView graphView() {
        return new GraphView();
    }

    public class GraphView
    implements Graph<HState<I, O, SP, TP>, HTransition<I, O, SP, TP>>,
    NodeIDs<HState<I, O, SP, TP>> {
        @Override
        public Collection<HState<I, O, SP, TP>> getNodes() {
            return Collections.unmodifiableCollection(OPLearnerHypothesis.this.nodes);
        }

        @Override
        public NodeIDs<HState<I, O, SP, TP>> nodeIDs() {
            return this;
        }

        @Override
        public Collection<HTransition<I, O, SP, TP>> getOutgoingEdges(HState<I, O, SP, TP> node) {
            return node.getOutgoingTransitions();
        }

        @Override
        public HState<I, O, SP, TP> getTarget(HTransition<I, O, SP, TP> edge) {
            return edge.currentTarget();
        }

        @Override
        public int getNodeId(HState<I, O, SP, TP> node) {
            return OPLearnerHypothesis.this.getStateId(node);
        }

        @Override
        public HState<I, O, SP, TP> getNode(int id) {
            return OPLearnerHypothesis.this.getState(id);
        }

        @Override
        public VisualizationHelper<HState<I, O, SP, TP>, HTransition<I, O, SP, TP>> getVisualizationHelper() {
            return new DefaultVisualizationHelper<HState<I, O, SP, TP>, HTransition<I, O, SP, TP>>(){

                @Override
                protected Collection<HState<I, O, SP, TP>> initialNodes() {
                    return Collections.singleton(OPLearnerHypothesis.this.root);
                }

                @Override
                public boolean getEdgeProperties(HState<I, O, SP, TP> src, HTransition<I, O, SP, TP> edge, HState<I, O, SP, TP> tgt, Map<String, String> properties) {
                    super.getEdgeProperties(src, edge, tgt, properties);
                    properties.put("label", String.valueOf(edge.getSymbol()));
                    if (edge.isTree()) {
                        properties.put("style", "bold");
                    }
                    return true;
                }
            };
        }
    }
}

