/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.observationpack.vpa;

import de.learnlib.AccessSequenceProvider;
import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.AbstractHypTrans;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.ContextPair;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.DTNode;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.DTree;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.HypIntTrans;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.HypLoc;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.HypRetTrans;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.OneSEVPAHypothesis;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.TransList;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.automatalib.alphabet.VPAlphabet;
import net.automatalib.automaton.vpa.OneSEVPA;
import net.automatalib.common.smartcollection.ElementReference;
import net.automatalib.common.smartcollection.UnorderedCollection;
import net.automatalib.word.Word;

public abstract class AbstractVPALearner<I>
implements LearningAlgorithm<OneSEVPA<?, I>, I, Boolean> {
    protected final VPAlphabet<I> alphabet;
    protected final MembershipOracle<I, Boolean> oracle;
    protected final DTree<I> dtree;
    protected final OneSEVPAHypothesis<I> hypothesis;
    protected final TransList<I> openTransitions = new TransList();

    public AbstractVPALearner(VPAlphabet<I> alphabet, MembershipOracle<I, Boolean> oracle) {
        this.alphabet = alphabet;
        this.oracle = oracle;
        this.dtree = new DTree<I>(oracle);
        ((DTNode)this.dtree.getRoot()).split(new ContextPair(Word.epsilon(), Word.epsilon()), false, true);
        this.hypothesis = new OneSEVPAHypothesis<I>(alphabet);
    }

    @Override
    public void startLearning() {
        HypLoc<I> initLoc = this.hypothesis.initialize();
        DTNode leaf = (DTNode)this.dtree.sift(initLoc.getAccessSequence());
        AbstractVPALearner.link(leaf, initLoc);
        this.initializeLocation(initLoc);
        this.closeTransitions();
    }

    @Override
    public boolean refineHypothesis(DefaultQuery<I, Boolean> ceQuery) {
        if (((Boolean)this.hypothesis.computeSuffixOutput((Iterable)ceQuery.getPrefix(), (Iterable)ceQuery.getSuffix())).equals(ceQuery.getOutput())) {
            return false;
        }
        while (this.refineHypothesisSingle(ceQuery)) {
        }
        return true;
    }

    protected abstract boolean refineHypothesisSingle(DefaultQuery<I, Boolean> var1);

    @Override
    public OneSEVPA<?, I> getHypothesisModel() {
        return this.hypothesis;
    }

    public DTree<I> getDiscriminationTree() {
        return this.dtree;
    }

    protected static <I> void link(DTNode<I> leaf, HypLoc<I> loc) {
        assert (leaf.isLeaf());
        leaf.setData(loc);
        loc.setLeaf(leaf);
    }

    protected void initializeLocation(HypLoc<I> loc) {
        int i;
        Boolean subtreeLabel = (Boolean)((DTNode)this.dtree.getRoot()).subtreeLabel(loc.getLeaf());
        assert (subtreeLabel != null);
        loc.setAccepting(subtreeLabel);
        for (i = 0; i < this.alphabet.getNumInternals(); ++i) {
            I intSym = this.alphabet.getInternalSymbol(i);
            HypIntTrans<I> trans = new HypIntTrans<I>(loc, intSym);
            loc.setInternalTransition(i, trans);
            this.openTransitions.add(trans);
        }
        loc.updateStackAlphabetSize(this.hypothesis.getNumStackSymbols());
        for (i = 0; i < this.alphabet.getNumCalls(); ++i) {
            I callSym = this.alphabet.getCallSymbol(i);
            int myStackSym = this.hypothesis.encodeStackSym(loc, i);
            for (HypLoc<I> stackLoc : this.hypothesis.getLocations()) {
                stackLoc.updateStackAlphabetSize(this.hypothesis.getNumStackSymbols());
                int stackSym = this.hypothesis.encodeStackSym(stackLoc, i);
                for (int j = 0; j < this.alphabet.getNumReturns(); ++j) {
                    I retSym = this.alphabet.getReturnSymbol(j);
                    HypRetTrans<I> trans = new HypRetTrans<I>(loc, retSym, callSym, stackLoc);
                    loc.setReturnTransition(j, stackSym, trans);
                    this.openTransitions.add(trans);
                    if (loc == stackLoc) continue;
                    HypRetTrans<I> retTrans = new HypRetTrans<I>(stackLoc, retSym, callSym, loc);
                    stackLoc.setReturnTransition(j, myStackSym, retTrans);
                    this.openTransitions.add(retTrans);
                }
            }
        }
    }

    protected void closeTransitions() {
        UnorderedCollection<DTNode<I>> newStateNodes = new UnorderedCollection<DTNode<I>>();
        do {
            newStateNodes.addAll((Collection<DTNode<I>>)this.closeTransitions(this.openTransitions, false));
            if (newStateNodes.isEmpty()) continue;
            this.addNewStates(newStateNodes);
        } while (!this.openTransitions.isEmpty());
    }

    private List<DTNode<I>> closeTransitions(TransList<I> transList, boolean hard) {
        AbstractHypTrans<I> t;
        ArrayList<AbstractHypTrans<I>> transToSift = new ArrayList<AbstractHypTrans<I>>(transList.size());
        while ((t = transList.poll()) != null) {
            if (t.isTree()) continue;
            transToSift.add(t);
        }
        if (transToSift.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<DTNode<I>> leavesIter = this.updateDTTargets(transToSift, hard).iterator();
        ArrayList<DTNode<I>> result = new ArrayList<DTNode<I>>(transToSift.size());
        for (AbstractHypTrans abstractHypTrans : transToSift) {
            DTNode<I> node = leavesIter.next();
            if (!node.isLeaf() || node.getData() != null || abstractHypTrans.getNextElement() != null) continue;
            result.add(node);
        }
        assert (!leavesIter.hasNext());
        return result;
    }

    private void addNewStates(UnorderedCollection<DTNode<I>> newStateNodes) {
        DTNode<I> minTransNode = null;
        AbstractHypTrans minTrans = null;
        int minAsLen = Integer.MAX_VALUE;
        ElementReference minTransNodeRef = null;
        for (ElementReference ref : newStateNodes.references()) {
            DTNode<I> newStateNode = newStateNodes.get(ref);
            for (AbstractHypTrans abstractHypTrans : newStateNode.getIncoming()) {
                Word as = abstractHypTrans.getAccessSequence();
                int asLen = as.length();
                if (asLen >= minAsLen) continue;
                minTransNode = newStateNode;
                minTrans = abstractHypTrans;
                minAsLen = asLen;
                minTransNodeRef = ref;
            }
        }
        assert (minTransNode != null);
        newStateNodes.remove(minTransNodeRef);
        assert (minTrans.getNonTreeTarget().getData() == null);
        HypLoc<I> newLoc = this.makeTree(minTrans);
        AbstractVPALearner.link(minTransNode, newLoc);
        this.initializeLocation(newLoc);
    }

    protected List<DTNode<I>> updateDTTargets(List<AbstractHypTrans<I>> trans, boolean hard) {
        ArrayList nodes = new ArrayList(trans.size());
        ArrayList prefixes = new ArrayList(trans.size());
        for (AbstractHypTrans<I> t : trans) {
            if (t.isTree()) continue;
            DTNode start = t.getNonTreeTarget();
            if (start == null) {
                t.setNonTreeTarget((DTNode)this.dtree.getRoot());
                start = (DTNode)this.dtree.getRoot();
            }
            nodes.add(start);
            prefixes.add(t.getAccessSequence());
        }
        Iterator<DTNode<I>> leavesIter = this.dtree.sift(nodes, prefixes, hard).iterator();
        ArrayList<DTNode<I>> result = new ArrayList<DTNode<I>>(trans.size());
        for (AbstractHypTrans<I> t : trans) {
            if (t.isTree()) {
                result.add(t.getTargetNode());
                continue;
            }
            DTNode<I> leaf = leavesIter.next();
            t.setNonTreeTarget(leaf);
            leaf.addIncoming(t);
            result.add(leaf);
        }
        assert (!leavesIter.hasNext());
        return result;
    }

    protected HypLoc<I> makeTree(AbstractHypTrans<I> trans) {
        assert (!trans.isTree());
        HypLoc<I> newLoc = this.createLocation(trans);
        trans.makeTree(newLoc);
        return newLoc;
    }

    protected HypLoc<I> createLocation(AbstractHypTrans<I> trans) {
        return this.hypothesis.createLocation(false, trans);
    }

    protected Boolean query(AccessSequenceProvider<I> asp, ContextPair<I> context) {
        return this.oracle.answerQuery(context.getPrefix().concat(asp.getAccessSequence()), context.getSuffix());
    }
}

