/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.observationpack.vpa.hypothesis;

import de.learnlib.algorithm.observationpack.vpa.hypothesis.AbstractHypTrans;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.HypLoc;
import java.util.ArrayList;
import java.util.List;
import net.automatalib.alphabet.VPAlphabet;
import net.automatalib.automaton.vpa.AbstractSEVPA;
import net.automatalib.automaton.vpa.OneSEVPA;
import net.automatalib.automaton.vpa.StackContents;
import net.automatalib.automaton.vpa.State;
import org.checkerframework.checker.nullness.qual.Nullable;

public class OneSEVPAHypothesis<I>
extends AbstractSEVPA<HypLoc<I>, I>
implements OneSEVPA<HypLoc<I>, I> {
    private final List<HypLoc<I>> locations = new ArrayList<HypLoc<I>>();
    private HypLoc<I> initLoc;

    public OneSEVPAHypothesis(VPAlphabet<I> alphabet) {
        super(alphabet);
    }

    public @Nullable AbstractHypTrans<I> getInternalTransition(State<HypLoc<I>> state, I sym) {
        switch (this.alphabet.getSymbolType(sym)) {
            case INTERNAL: {
                return state.getLocation().getInternalTransition(this.alphabet.getInternalSymbolIndex(sym));
            }
            case RETURN: {
                StackContents stackContents = state.getStackContents();
                assert (stackContents != null);
                return state.getLocation().getReturnTransition(this.alphabet.getReturnSymbolIndex(sym), stackContents.peek());
            }
        }
        return null;
    }

    public AbstractHypTrans<I> getInternalTransition(HypLoc<I> loc, I intSym) {
        return loc.getInternalTransition(this.alphabet.getInternalSymbolIndex(intSym));
    }

    public AbstractHypTrans<I> getReturnTransition(HypLoc<I> loc, I retSym, int stackSym) {
        return loc.getReturnTransition(this.alphabet.getReturnSymbolIndex(retSym), stackSym);
    }

    public AbstractHypTrans<I> getReturnTransition(HypLoc<I> loc, I retSym, HypLoc<I> stackLoc, I callSym) {
        int stackSym = this.encodeStackSym(stackLoc, callSym);
        return loc.getReturnTransition(this.alphabet.getReturnSymbolIndex(retSym), stackSym);
    }

    public HypLoc<I> createLocation(boolean accepting, AbstractHypTrans<I> treeIncoming) {
        HypLoc<I> loc = new HypLoc<I>(this.alphabet, this.locations.size(), accepting, treeIncoming);
        this.locations.add(loc);
        return loc;
    }

    public HypLoc<I> initialize() {
        HypLoc<I> loc = this.createLocation(false, null);
        this.initLoc = loc;
        return loc;
    }

    @Override
    public HypLoc<I> getInternalSuccessor(HypLoc<I> loc, I intSym) {
        return loc.getInternalTransition(this.alphabet.getInternalSymbolIndex(intSym)).getTargetLocation();
    }

    @Override
    public HypLoc<I> getLocation(int id) {
        return this.locations.get(id);
    }

    @Override
    public int getLocationId(HypLoc<I> loc) {
        return loc.getIndex();
    }

    @Override
    public List<HypLoc<I>> getLocations() {
        return this.locations;
    }

    @Override
    public HypLoc<I> getReturnSuccessor(HypLoc<I> loc, I retSym, int stackSym) {
        return loc.getReturnTransition(this.alphabet.getReturnSymbolIndex(retSym), stackSym).getTargetLocation();
    }

    @Override
    public boolean isAcceptingLocation(HypLoc<I> loc) {
        return loc.isAccepting();
    }

    @Override
    public HypLoc<I> getInitialLocation() {
        return this.initLoc;
    }

    @Override
    public int size() {
        return this.locations.size();
    }
}

