/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.oml.lstar;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.oml.lstar.AbstractOptimalLStar;
import de.learnlib.oracle.MembershipOracle;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.CompactMealy;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.word.Word;

public class OptimalLStarMealy<I, O>
extends AbstractOptimalLStar<MealyMachine<?, I, ?, O>, I, Word<O>>
implements LearningAlgorithm.MealyLearner<I, O> {
    private CompactMealy<I, O> hypothesis;
    private MutableMapping<Integer, List<Word<O>>> hypStateMap;

    public OptimalLStarMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> mqo) {
        this(alphabet, mqo, mqo);
    }

    public OptimalLStarMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> mqs, MembershipOracle<I, Word<O>> ceqs) {
        super(alphabet, mqs, ceqs, Collections.emptyList());
    }

    @Override
    public int size() {
        return this.hypothesis.size();
    }

    @Override
    public List<Word<O>> rowForState(Word<I> input) {
        return (List)this.hypStateMap.get((Integer)this.hypothesis.getState(input));
    }

    @Override
    public Word<O> getOutput(Word<I> input, int length) {
        assert (!input.isEmpty());
        return ((Word)this.hypothesis.computeOutput(input)).suffix(length);
    }

    @Override
    public MealyMachine<?, I, ?, O> getHypothesisModel() {
        return this.hypothesis;
    }

    @Override
    int maxSearchIndex(int ceLength) {
        return ceLength;
    }

    @Override
    boolean symbolInconsistency(Word<I> u1, Word<I> u2, I a) {
        Object o2;
        Word<I> suff = Word.fromLetter(a);
        Object o1 = ((Word)this.mqs.answerQuery(u1, suff)).lastSymbol();
        if (!Objects.equals(o1, o2 = ((Word)this.mqs.answerQuery(u2, suff)).lastSymbol())) {
            this.addSuffix(suff);
            return true;
        }
        return false;
    }

    @Override
    void automatonFromTable() {
        Alphabet alphabet = this.getInputAlphabet();
        this.hypothesis = new CompactMealy(alphabet);
        HashMap stateMap = new HashMap();
        List rowData = this.getRow(Word.epsilon());
        Integer q = (Integer)this.hypothesis.addInitialState();
        stateMap.put(rowData, q);
        for (Word word : this.getShortPrefixes()) {
            rowData = this.getRow(word);
            if (stateMap.containsKey(rowData)) continue;
            q = (Integer)this.hypothesis.addState();
            stateMap.put(rowData, q);
        }
        this.hypStateMap = this.hypothesis.createStaticStateMapping();
        for (Map.Entry entry : stateMap.entrySet()) {
            List sig = (List)entry.getKey();
            Integer state = (Integer)entry.getValue();
            this.hypStateMap.put(state, sig);
            Word u = this.getShortPrefixes(sig).get(0);
            for (Object a : alphabet) {
                Word ua = u.append(a);
                List destData = this.getRow(ua);
                assert (destData != null);
                Integer dst = (Integer)stateMap.get(destData);
                Object o = ((Word)this.mqs.answerQuery(ua)).lastSymbol();
                this.hypothesis.setTransition(state, a, dst, o);
            }
        }
    }

    @Override
    Word<O> suffix(Word<O> output, int length) {
        return output.suffix(length);
    }
}

