/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.oml.ttt.st;

import de.learnlib.algorithm.oml.ttt.st.STNode;
import java.util.HashMap;
import java.util.Map;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

class STNodeImpl<I>
implements STNode<I> {
    private final @Nullable STNodeImpl<I> parent;
    private final @Nullable I symbol;
    private final Map<I, STNodeImpl<I>> children;

    STNodeImpl(@Nullable STNodeImpl<I> parent, @Nullable I symbol) {
        this.parent = parent;
        this.symbol = symbol;
        this.children = new HashMap<I, STNodeImpl<I>>();
    }

    @Override
    public Word<I> word() {
        return this.toWord(Word.epsilon());
    }

    private Word<I> toWord(Word<I> prefix) {
        if (this.symbol == null || this.parent == null) {
            return prefix;
        }
        return super.toWord(prefix.append(this.symbol));
    }

    @Override
    public STNodeImpl<I> prepend(I a) {
        STNodeImpl<I> n = this.children.get(a);
        if (n == null) {
            n = new STNodeImpl<I>(this, a);
            this.children.put(a, n);
        }
        return n;
    }
}

