/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.ostia;

import java.util.HashSet;
import java.util.StringJoiner;
import net.automatalib.common.smartcollection.IntSeq;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;

class IntQueue {
    int value;
    @Nullable IntQueue next;

    IntQueue() {
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        IntQueue iter = this;
        while (iter != null) {
            sj.add(Integer.toString(iter.value));
            iter = iter.next;
        }
        return sj.toString();
    }

    static @Nullable IntQueue asQueue(IntSeq str) {
        IntQueue q = null;
        for (int i = str.size() - 1; i >= 0; --i) {
            IntQueue next = new IntQueue();
            next.value = str.get(i);
            next.next = q;
            q = next;
        }
        assert (!IntQueue.hasCycle(q));
        return q;
    }

    static boolean eq(@Nullable IntQueue a, @Nullable IntQueue b) {
        IntQueue aIter = a;
        IntQueue bIter = b;
        while (aIter != null && bIter != null) {
            if (aIter.value != bIter.value) {
                return false;
            }
            aIter = aIter.next;
            bIter = bIter.next;
        }
        return aIter == null && bIter == null;
    }

    static boolean hasCycle(@Nullable IntQueue q) {
        HashSet<IntQueue> elements = new HashSet<IntQueue>();
        IntQueue iter = q;
        while (iter != null) {
            if (!elements.add(iter)) {
                return true;
            }
            iter = iter.next;
        }
        return false;
    }

    static @PolyNull IntQueue copyAndConcat(@Nullable IntQueue q, @PolyNull IntQueue tail) {
        assert (!IntQueue.hasCycle(q) && !IntQueue.hasCycle(tail));
        if (q == null) {
            return tail;
        }
        IntQueue root = new IntQueue();
        root.value = q.value;
        IntQueue curr = root;
        IntQueue iter = q.next;
        while (iter != null) {
            curr = curr.next = new IntQueue();
            curr.value = iter.value;
            iter = iter.next;
        }
        curr.next = tail;
        assert (!IntQueue.hasCycle(root));
        return root;
    }
}

