/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.procedural.sba.manager;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.learnlib.AccessSequenceTransformer;
import de.learnlib.algorithm.procedural.SymbolWrapper;
import de.learnlib.algorithm.procedural.sba.ATManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.common.util.Pair;
import net.automatalib.word.Word;

public class DefaultATManager<I>
implements ATManager<I> {
    private final Map<I, Word<I>> accessSequences;
    private final Map<I, Word<I>> terminatingSequences;
    private final ProceduralInputAlphabet<I> alphabet;

    public DefaultATManager(ProceduralInputAlphabet<I> alphabet) {
        this.alphabet = alphabet;
        this.accessSequences = Maps.newHashMapWithExpectedSize(alphabet.getNumCalls());
        this.terminatingSequences = Maps.newHashMapWithExpectedSize(alphabet.getNumCalls());
    }

    @Override
    public Word<I> getAccessSequence(I procedure) {
        assert (this.accessSequences.containsKey(procedure));
        return this.accessSequences.get(procedure);
    }

    @Override
    public Word<I> getTerminatingSequence(I procedure) {
        assert (this.terminatingSequences.containsKey(procedure));
        return this.terminatingSequences.get(procedure);
    }

    @Override
    public Pair<Set<I>, Set<I>> scanPositiveCounterexample(Word<I> input) {
        HashSet<I> newCalls = Sets.newHashSetWithExpectedSize(this.alphabet.getNumCalls() - this.accessSequences.size());
        HashSet<I> newTerms = Sets.newHashSetWithExpectedSize(this.alphabet.getNumCalls() - this.terminatingSequences.size());
        for (int i = 0; i < input.size(); ++i) {
            int returnIdx;
            I sym = input.getSymbol(i);
            if (!this.alphabet.isCallSymbol(sym)) continue;
            if (!this.accessSequences.containsKey(sym)) {
                this.accessSequences.put(sym, input.prefix(i + 1));
                newCalls.add(sym);
            }
            if ((returnIdx = this.alphabet.findReturnIndex(input, i + 1)) <= 0 || this.terminatingSequences.containsKey(sym)) continue;
            this.terminatingSequences.put(sym, input.subWord(i + 1, returnIdx));
            newTerms.add(sym);
        }
        return Pair.of(newCalls, newTerms);
    }

    @Override
    public Set<I> scanProcedures(Map<I, ? extends DFA<?, SymbolWrapper<I>>> procedures, Map<I, ? extends AccessSequenceTransformer<SymbolWrapper<I>>> providers, Collection<SymbolWrapper<I>> inputs) {
        return Collections.emptySet();
    }
}

