/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.procedural.spmm;

import com.google.common.collect.Maps;
import de.learnlib.algorithm.procedural.SymbolWrapper;
import java.util.Collection;
import java.util.Map;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.procedural.SPMM;
import net.automatalib.automaton.transducer.MealyMachine;
import org.checkerframework.checker.nullness.qual.Nullable;

class MappingSPMM<S, I, T, O>
implements SPMM<S, I, T, O> {
    private final ProceduralInputAlphabet<I> alphabet;
    private final O errorOutput;
    private final Map<I, SymbolWrapper<I>> mapping;
    private final SPMM<S, SymbolWrapper<I>, T, O> delegate;
    private final Map<I, MealyMachine<?, I, ?, O>> procedures;

    MappingSPMM(ProceduralInputAlphabet<I> alphabet, O errorOutput, Map<I, SymbolWrapper<I>> mapping, SPMM<S, SymbolWrapper<I>, T, O> delegate) {
        this.alphabet = alphabet;
        this.errorOutput = errorOutput;
        this.mapping = mapping;
        this.delegate = delegate;
        Map p = delegate.getProcedures();
        this.procedures = Maps.newHashMapWithExpectedSize(p.size());
        for (Map.Entry e : p.entrySet()) {
            this.procedures.put(((SymbolWrapper)e.getKey()).getDelegate(), new MealyView((MealyMachine)e.getValue()));
        }
    }

    @Override
    public @Nullable T getTransition(S state, I i) {
        SymbolWrapper<I> w = this.mapping.get(i);
        return w == null ? null : (T)this.delegate.getTransition(state, w);
    }

    @Override
    public S getInitialState() {
        return this.delegate.getInitialState();
    }

    @Override
    public @Nullable I getInitialProcedure() {
        SymbolWrapper init = (SymbolWrapper)this.delegate.getInitialProcedure();
        return init == null ? null : (I)init.getDelegate();
    }

    @Override
    public ProceduralInputAlphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    @Override
    public O getErrorOutput() {
        return this.errorOutput;
    }

    @Override
    public O getTransitionOutput(T transition) {
        return this.delegate.getTransitionOutput(transition);
    }

    @Override
    public S getSuccessor(T transition) {
        return this.delegate.getSuccessor(transition);
    }

    @Override
    public Map<I, MealyMachine<?, I, ?, O>> getProcedures() {
        return this.procedures;
    }

    private class MealyView<S2, T2>
    implements MealyMachine<S2, I, T2, O> {
        private final MealyMachine<S2, SymbolWrapper<I>, T2, O> delegate;

        MealyView(MealyMachine<S2, SymbolWrapper<I>, T2, O> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Collection<S2> getStates() {
            return this.delegate.getStates();
        }

        @Override
        public O getTransitionOutput(T2 t2) {
            return this.delegate.getTransitionOutput(t2);
        }

        @Override
        public @Nullable T2 getTransition(S2 s2, I i) {
            SymbolWrapper w = (SymbolWrapper)MappingSPMM.this.mapping.get(i);
            return w == null ? null : (T2)this.delegate.getTransition(s2, w);
        }

        @Override
        public S2 getSuccessor(T2 t2) {
            return (S2)this.delegate.getSuccessor(t2);
        }

        @Override
        public @Nullable S2 getInitialState() {
            return (S2)this.delegate.getInitialState();
        }
    }
}

